/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.DeviceConnectionType;
import java.io.IOException;

public final class NetworkInterface
implements JsonSerializable<NetworkInterface> {
    private String address;
    private DeviceConnectionType deviceConnectionType;
    private String model;
    private Long physicalSlot;
    private Long portCount;
    private Long portSpeed;
    private String vendor;

    public String address() {
        return this.address;
    }

    public DeviceConnectionType deviceConnectionType() {
        return this.deviceConnectionType;
    }

    public String model() {
        return this.model;
    }

    public Long physicalSlot() {
        return this.physicalSlot;
    }

    public Long portCount() {
        return this.portCount;
    }

    public Long portSpeed() {
        return this.portSpeed;
    }

    public String vendor() {
        return this.vendor;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static NetworkInterface fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkInterface)jsonReader.readObject(reader -> {
            NetworkInterface deserializedNetworkInterface = new NetworkInterface();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("address".equals(fieldName)) {
                    deserializedNetworkInterface.address = reader.getString();
                    continue;
                }
                if ("deviceConnectionType".equals(fieldName)) {
                    deserializedNetworkInterface.deviceConnectionType = DeviceConnectionType.fromString(reader.getString());
                    continue;
                }
                if ("model".equals(fieldName)) {
                    deserializedNetworkInterface.model = reader.getString();
                    continue;
                }
                if ("physicalSlot".equals(fieldName)) {
                    deserializedNetworkInterface.physicalSlot = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("portCount".equals(fieldName)) {
                    deserializedNetworkInterface.portCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("portSpeed".equals(fieldName)) {
                    deserializedNetworkInterface.portSpeed = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("vendor".equals(fieldName)) {
                    deserializedNetworkInterface.vendor = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkInterface;
        });
    }
}

