/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.KubernetesPluginType;
import com.azure.resourcemanager.networkcloud.models.L3NetworkConfigurationIpamEnabled;
import java.io.IOException;

public final class L3NetworkAttachmentConfiguration
implements JsonSerializable<L3NetworkAttachmentConfiguration> {
    private L3NetworkConfigurationIpamEnabled ipamEnabled;
    private String networkId;
    private KubernetesPluginType pluginType;
    private static final ClientLogger LOGGER = new ClientLogger(L3NetworkAttachmentConfiguration.class);

    public L3NetworkConfigurationIpamEnabled ipamEnabled() {
        return this.ipamEnabled;
    }

    public L3NetworkAttachmentConfiguration withIpamEnabled(L3NetworkConfigurationIpamEnabled ipamEnabled) {
        this.ipamEnabled = ipamEnabled;
        return this;
    }

    public String networkId() {
        return this.networkId;
    }

    public L3NetworkAttachmentConfiguration withNetworkId(String networkId) {
        this.networkId = networkId;
        return this;
    }

    public KubernetesPluginType pluginType() {
        return this.pluginType;
    }

    public L3NetworkAttachmentConfiguration withPluginType(KubernetesPluginType pluginType) {
        this.pluginType = pluginType;
        return this;
    }

    public void validate() {
        if (this.networkId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property networkId in model L3NetworkAttachmentConfiguration"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("networkId", this.networkId);
        jsonWriter.writeStringField("ipamEnabled", this.ipamEnabled == null ? null : this.ipamEnabled.toString());
        jsonWriter.writeStringField("pluginType", this.pluginType == null ? null : this.pluginType.toString());
        return jsonWriter.writeEndObject();
    }

    public static L3NetworkAttachmentConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (L3NetworkAttachmentConfiguration)jsonReader.readObject(reader -> {
            L3NetworkAttachmentConfiguration deserializedL3NetworkAttachmentConfiguration = new L3NetworkAttachmentConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("networkId".equals(fieldName)) {
                    deserializedL3NetworkAttachmentConfiguration.networkId = reader.getString();
                    continue;
                }
                if ("ipamEnabled".equals(fieldName)) {
                    deserializedL3NetworkAttachmentConfiguration.ipamEnabled = L3NetworkConfigurationIpamEnabled.fromString(reader.getString());
                    continue;
                }
                if ("pluginType".equals(fieldName)) {
                    deserializedL3NetworkAttachmentConfiguration.pluginType = KubernetesPluginType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedL3NetworkAttachmentConfiguration;
        });
    }
}

