/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.BmcKeySetPatchProperties;
import com.azure.resourcemanager.networkcloud.models.KeySetUser;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class BmcKeySetPatchParameters
implements JsonSerializable<BmcKeySetPatchParameters> {
    private BmcKeySetPatchProperties innerProperties;
    private Map<String, String> tags;

    private BmcKeySetPatchProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public BmcKeySetPatchParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public OffsetDateTime expiration() {
        return this.innerProperties() == null ? null : this.innerProperties().expiration();
    }

    public BmcKeySetPatchParameters withExpiration(OffsetDateTime expiration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BmcKeySetPatchProperties();
        }
        this.innerProperties().withExpiration(expiration);
        return this;
    }

    public List<KeySetUser> userList() {
        return this.innerProperties() == null ? null : this.innerProperties().userList();
    }

    public BmcKeySetPatchParameters withUserList(List<KeySetUser> userList) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BmcKeySetPatchProperties();
        }
        this.innerProperties().withUserList(userList);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static BmcKeySetPatchParameters fromJson(JsonReader jsonReader) throws IOException {
        return (BmcKeySetPatchParameters)jsonReader.readObject(reader -> {
            BmcKeySetPatchParameters deserializedBmcKeySetPatchParameters = new BmcKeySetPatchParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedBmcKeySetPatchParameters.innerProperties = BmcKeySetPatchProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedBmcKeySetPatchParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBmcKeySetPatchParameters;
        });
    }
}

