/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.fluent.models.BareMetalMachineKeySetInner;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineKeySetDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineKeySetPrivilegeLevel;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineKeySetProvisioningState;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.KeySetUser;
import com.azure.resourcemanager.networkcloud.models.KeySetUserStatus;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public interface BareMetalMachineKeySet {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public String etag();

    public ExtendedLocation extendedLocation();

    public SystemData systemData();

    public String azureGroupId();

    public BareMetalMachineKeySetDetailedStatus detailedStatus();

    public String detailedStatusMessage();

    public OffsetDateTime expiration();

    public List<String> jumpHostsAllowed();

    public OffsetDateTime lastValidation();

    public String osGroupName();

    public BareMetalMachineKeySetPrivilegeLevel privilegeLevel();

    public String privilegeLevelName();

    public BareMetalMachineKeySetProvisioningState provisioningState();

    public List<KeySetUser> userList();

    public List<KeySetUserStatus> userListStatus();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public BareMetalMachineKeySetInner innerModel();

    public Update update();

    public BareMetalMachineKeySet refresh();

    public BareMetalMachineKeySet refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithIfNoneMatch {
            public Update withIfNoneMatch(String var1);
        }

        public static interface WithIfMatch {
            public Update withIfMatch(String var1);
        }

        public static interface WithUserList {
            public Update withUserList(List<KeySetUser> var1);
        }

        public static interface WithJumpHostsAllowed {
            public Update withJumpHostsAllowed(List<String> var1);
        }

        public static interface WithExpiration {
            public Update withExpiration(OffsetDateTime var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithExpiration,
    UpdateStages.WithJumpHostsAllowed,
    UpdateStages.WithUserList,
    UpdateStages.WithIfMatch,
    UpdateStages.WithIfNoneMatch {
        public BareMetalMachineKeySet apply();

        public BareMetalMachineKeySet apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIfNoneMatch {
            public WithCreate withIfNoneMatch(String var1);
        }

        public static interface WithIfMatch {
            public WithCreate withIfMatch(String var1);
        }

        public static interface WithPrivilegeLevelName {
            public WithCreate withPrivilegeLevelName(String var1);
        }

        public static interface WithOsGroupName {
            public WithCreate withOsGroupName(String var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithOsGroupName,
        WithPrivilegeLevelName,
        WithIfMatch,
        WithIfNoneMatch {
            public BareMetalMachineKeySet create();

            public BareMetalMachineKeySet create(Context var1);
        }

        public static interface WithUserList {
            public WithCreate withUserList(List<KeySetUser> var1);
        }

        public static interface WithPrivilegeLevel {
            public WithUserList withPrivilegeLevel(BareMetalMachineKeySetPrivilegeLevel var1);
        }

        public static interface WithJumpHostsAllowed {
            public WithPrivilegeLevel withJumpHostsAllowed(List<String> var1);
        }

        public static interface WithExpiration {
            public WithJumpHostsAllowed withExpiration(OffsetDateTime var1);
        }

        public static interface WithAzureGroupId {
            public WithExpiration withAzureGroupId(String var1);
        }

        public static interface WithExtendedLocation {
            public WithAzureGroupId withExtendedLocation(ExtendedLocation var1);
        }

        public static interface WithParentResource {
            public WithExtendedLocation withExistingCluster(String var1, String var2);
        }

        public static interface WithLocation {
            public WithParentResource withRegion(Region var1);

            public WithParentResource withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithExtendedLocation,
    DefinitionStages.WithAzureGroupId,
    DefinitionStages.WithExpiration,
    DefinitionStages.WithJumpHostsAllowed,
    DefinitionStages.WithPrivilegeLevel,
    DefinitionStages.WithUserList,
    DefinitionStages.WithCreate {
    }
}

