/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.KubernetesClustersClient;
import com.azure.resourcemanager.networkcloud.fluent.models.KubernetesClusterInner;
import com.azure.resourcemanager.networkcloud.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.networkcloud.implementation.KubernetesClusterImpl;
import com.azure.resourcemanager.networkcloud.implementation.OperationStatusResultImpl;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.models.KubernetesCluster;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterRestartNodeParameters;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusters;
import com.azure.resourcemanager.networkcloud.models.OperationStatusResult;

public final class KubernetesClustersImpl
implements KubernetesClusters {
    private static final ClientLogger LOGGER = new ClientLogger(KubernetesClustersImpl.class);
    private final KubernetesClustersClient innerClient;
    private final NetworkCloudManager serviceManager;

    public KubernetesClustersImpl(KubernetesClustersClient innerClient, NetworkCloudManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<KubernetesCluster> list() {
        PagedIterable<KubernetesClusterInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new KubernetesClusterImpl((KubernetesClusterInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<KubernetesCluster> list(Integer top, String skipToken, Context context) {
        PagedIterable<KubernetesClusterInner> inner = this.serviceClient().list(top, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new KubernetesClusterImpl((KubernetesClusterInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<KubernetesCluster> listByResourceGroup(String resourceGroupName) {
        PagedIterable<KubernetesClusterInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new KubernetesClusterImpl((KubernetesClusterInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<KubernetesCluster> listByResourceGroup(String resourceGroupName, Integer top, String skipToken, Context context) {
        PagedIterable<KubernetesClusterInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, top, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new KubernetesClusterImpl((KubernetesClusterInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<KubernetesCluster> getByResourceGroupWithResponse(String resourceGroupName, String kubernetesClusterName, Context context) {
        Response<KubernetesClusterInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, kubernetesClusterName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new KubernetesClusterImpl((KubernetesClusterInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public KubernetesCluster getByResourceGroup(String resourceGroupName, String kubernetesClusterName) {
        KubernetesClusterInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, kubernetesClusterName);
        if (inner != null) {
            return new KubernetesClusterImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult deleteByResourceGroup(String resourceGroupName, String kubernetesClusterName) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, kubernetesClusterName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult delete(String resourceGroupName, String kubernetesClusterName, String ifMatch, String ifNoneMatch, Context context) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, kubernetesClusterName, ifMatch, ifNoneMatch, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult restartNode(String resourceGroupName, String kubernetesClusterName, KubernetesClusterRestartNodeParameters kubernetesClusterRestartNodeParameters) {
        OperationStatusResultInner inner = this.serviceClient().restartNode(resourceGroupName, kubernetesClusterName, kubernetesClusterRestartNodeParameters);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult restartNode(String resourceGroupName, String kubernetesClusterName, KubernetesClusterRestartNodeParameters kubernetesClusterRestartNodeParameters, Context context) {
        OperationStatusResultInner inner = this.serviceClient().restartNode(resourceGroupName, kubernetesClusterName, kubernetesClusterRestartNodeParameters, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public KubernetesCluster getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String kubernetesClusterName = ResourceManagerUtils.getValueFromIdByName(id, "kubernetesClusters");
        if (kubernetesClusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'kubernetesClusters'.", id)));
        }
        return (KubernetesCluster)this.getByResourceGroupWithResponse(resourceGroupName, kubernetesClusterName, Context.NONE).getValue();
    }

    @Override
    public Response<KubernetesCluster> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String kubernetesClusterName = ResourceManagerUtils.getValueFromIdByName(id, "kubernetesClusters");
        if (kubernetesClusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'kubernetesClusters'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, kubernetesClusterName, context);
    }

    @Override
    public OperationStatusResult deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String kubernetesClusterName = ResourceManagerUtils.getValueFromIdByName(id, "kubernetesClusters");
        if (kubernetesClusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'kubernetesClusters'.", id)));
        }
        String localIfMatch = null;
        String localIfNoneMatch = null;
        return this.delete(resourceGroupName, kubernetesClusterName, localIfMatch, localIfNoneMatch, Context.NONE);
    }

    @Override
    public OperationStatusResult deleteByIdWithResponse(String id, String ifMatch, String ifNoneMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String kubernetesClusterName = ResourceManagerUtils.getValueFromIdByName(id, "kubernetesClusters");
        if (kubernetesClusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'kubernetesClusters'.", id)));
        }
        return this.delete(resourceGroupName, kubernetesClusterName, ifMatch, ifNoneMatch, context);
    }

    private KubernetesClustersClient serviceClient() {
        return this.innerClient;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public KubernetesClusterImpl define(String name) {
        return new KubernetesClusterImpl(name, this.manager());
    }
}

