/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.networkcloud.fluent.KubernetesClusterFeaturesClient;
import com.azure.resourcemanager.networkcloud.fluent.models.KubernetesClusterFeatureInner;
import com.azure.resourcemanager.networkcloud.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.networkcloud.implementation.NetworkCloudImpl;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterFeatureList;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterFeaturePatchParameters;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class KubernetesClusterFeaturesClientImpl
implements KubernetesClusterFeaturesClient {
    private final KubernetesClusterFeaturesService service;
    private final NetworkCloudImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(KubernetesClusterFeaturesClientImpl.class);

    KubernetesClusterFeaturesClientImpl(NetworkCloudImpl client) {
        this.service = (KubernetesClusterFeaturesService)RestProxy.create(KubernetesClusterFeaturesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<KubernetesClusterFeatureInner>> listByKubernetesClusterSinglePageAsync(String resourceGroupName, String kubernetesClusterName, Integer top, String skipToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByKubernetesCluster(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, top, skipToken, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KubernetesClusterFeatureList)res.getValue()).value(), ((KubernetesClusterFeatureList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<KubernetesClusterFeatureInner> listByKubernetesClusterAsync(String resourceGroupName, String kubernetesClusterName, Integer top, String skipToken) {
        return new PagedFlux(() -> this.listByKubernetesClusterSinglePageAsync(resourceGroupName, kubernetesClusterName, top, skipToken), nextLink -> this.listByKubernetesClusterNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<KubernetesClusterFeatureInner> listByKubernetesClusterAsync(String resourceGroupName, String kubernetesClusterName) {
        Integer top = null;
        String skipToken = null;
        return new PagedFlux(() -> this.listByKubernetesClusterSinglePageAsync(resourceGroupName, kubernetesClusterName, top, skipToken), nextLink -> this.listByKubernetesClusterNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<KubernetesClusterFeatureInner> listByKubernetesClusterSinglePage(String resourceGroupName, String kubernetesClusterName, Integer top, String skipToken) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<KubernetesClusterFeatureList> res = this.service.listByKubernetesClusterSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, top, skipToken, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KubernetesClusterFeatureList)res.getValue()).value(), ((KubernetesClusterFeatureList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<KubernetesClusterFeatureInner> listByKubernetesClusterSinglePage(String resourceGroupName, String kubernetesClusterName, Integer top, String skipToken, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<KubernetesClusterFeatureList> res = this.service.listByKubernetesClusterSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, top, skipToken, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KubernetesClusterFeatureList)res.getValue()).value(), ((KubernetesClusterFeatureList)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KubernetesClusterFeatureInner> listByKubernetesCluster(String resourceGroupName, String kubernetesClusterName) {
        Integer top = null;
        String skipToken = null;
        return new PagedIterable(() -> this.listByKubernetesClusterSinglePage(resourceGroupName, kubernetesClusterName, top, skipToken), nextLink -> this.listByKubernetesClusterNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KubernetesClusterFeatureInner> listByKubernetesCluster(String resourceGroupName, String kubernetesClusterName, Integer top, String skipToken, Context context) {
        return new PagedIterable(() -> this.listByKubernetesClusterSinglePage(resourceGroupName, kubernetesClusterName, top, skipToken, context), nextLink -> this.listByKubernetesClusterNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<KubernetesClusterFeatureInner>> getWithResponseAsync(String resourceGroupName, String kubernetesClusterName, String featureName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (featureName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter featureName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, featureName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<KubernetesClusterFeatureInner> getAsync(String resourceGroupName, String kubernetesClusterName, String featureName) {
        return this.getWithResponseAsync(resourceGroupName, kubernetesClusterName, featureName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((KubernetesClusterFeatureInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KubernetesClusterFeatureInner> getWithResponse(String resourceGroupName, String kubernetesClusterName, String featureName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (featureName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter featureName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, featureName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public KubernetesClusterFeatureInner get(String resourceGroupName, String kubernetesClusterName, String featureName) {
        return (KubernetesClusterFeatureInner)((Object)this.getWithResponse(resourceGroupName, kubernetesClusterName, featureName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String kubernetesClusterName, String featureName, KubernetesClusterFeatureInner kubernetesClusterFeatureParameters, String ifMatch, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (featureName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter featureName is required and cannot be null."));
        }
        if (kubernetesClusterFeatureParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterFeatureParameters is required and cannot be null."));
        }
        kubernetesClusterFeatureParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, featureName, ifMatch, ifNoneMatch, kubernetesClusterFeatureParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String kubernetesClusterName, String featureName, KubernetesClusterFeatureInner kubernetesClusterFeatureParameters, String ifMatch, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (featureName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter featureName is required and cannot be null."));
        }
        if (kubernetesClusterFeatureParameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter kubernetesClusterFeatureParameters is required and cannot be null."));
        }
        kubernetesClusterFeatureParameters.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, featureName, ifMatch, ifNoneMatch, kubernetesClusterFeatureParameters, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String kubernetesClusterName, String featureName, KubernetesClusterFeatureInner kubernetesClusterFeatureParameters, String ifMatch, String ifNoneMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (featureName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter featureName is required and cannot be null."));
        }
        if (kubernetesClusterFeatureParameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter kubernetesClusterFeatureParameters is required and cannot be null."));
        }
        kubernetesClusterFeatureParameters.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, featureName, ifMatch, ifNoneMatch, kubernetesClusterFeatureParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<KubernetesClusterFeatureInner>, KubernetesClusterFeatureInner> beginCreateOrUpdateAsync(String resourceGroupName, String kubernetesClusterName, String featureName, KubernetesClusterFeatureInner kubernetesClusterFeatureParameters, String ifMatch, String ifNoneMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, kubernetesClusterName, featureName, kubernetesClusterFeatureParameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)KubernetesClusterFeatureInner.class), (Type)((Object)KubernetesClusterFeatureInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<KubernetesClusterFeatureInner>, KubernetesClusterFeatureInner> beginCreateOrUpdateAsync(String resourceGroupName, String kubernetesClusterName, String featureName, KubernetesClusterFeatureInner kubernetesClusterFeatureParameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, kubernetesClusterName, featureName, kubernetesClusterFeatureParameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)KubernetesClusterFeatureInner.class), (Type)((Object)KubernetesClusterFeatureInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<KubernetesClusterFeatureInner>, KubernetesClusterFeatureInner> beginCreateOrUpdate(String resourceGroupName, String kubernetesClusterName, String featureName, KubernetesClusterFeatureInner kubernetesClusterFeatureParameters, String ifMatch, String ifNoneMatch) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, kubernetesClusterName, featureName, kubernetesClusterFeatureParameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(response, (Type)((Object)KubernetesClusterFeatureInner.class), (Type)((Object)KubernetesClusterFeatureInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<KubernetesClusterFeatureInner>, KubernetesClusterFeatureInner> beginCreateOrUpdate(String resourceGroupName, String kubernetesClusterName, String featureName, KubernetesClusterFeatureInner kubernetesClusterFeatureParameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, kubernetesClusterName, featureName, kubernetesClusterFeatureParameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(response, (Type)((Object)KubernetesClusterFeatureInner.class), (Type)((Object)KubernetesClusterFeatureInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<KubernetesClusterFeatureInner>, KubernetesClusterFeatureInner> beginCreateOrUpdate(String resourceGroupName, String kubernetesClusterName, String featureName, KubernetesClusterFeatureInner kubernetesClusterFeatureParameters, String ifMatch, String ifNoneMatch, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, kubernetesClusterName, featureName, kubernetesClusterFeatureParameters, ifMatch, ifNoneMatch, context);
        return this.client.getLroResult(response, (Type)((Object)KubernetesClusterFeatureInner.class), (Type)((Object)KubernetesClusterFeatureInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<KubernetesClusterFeatureInner> createOrUpdateAsync(String resourceGroupName, String kubernetesClusterName, String featureName, KubernetesClusterFeatureInner kubernetesClusterFeatureParameters, String ifMatch, String ifNoneMatch) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, kubernetesClusterName, featureName, kubernetesClusterFeatureParameters, ifMatch, ifNoneMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<KubernetesClusterFeatureInner> createOrUpdateAsync(String resourceGroupName, String kubernetesClusterName, String featureName, KubernetesClusterFeatureInner kubernetesClusterFeatureParameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return this.beginCreateOrUpdateAsync(resourceGroupName, kubernetesClusterName, featureName, kubernetesClusterFeatureParameters, ifMatch, ifNoneMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public KubernetesClusterFeatureInner createOrUpdate(String resourceGroupName, String kubernetesClusterName, String featureName, KubernetesClusterFeatureInner kubernetesClusterFeatureParameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return (KubernetesClusterFeatureInner)((Object)this.beginCreateOrUpdate(resourceGroupName, kubernetesClusterName, featureName, kubernetesClusterFeatureParameters, ifMatch, ifNoneMatch).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public KubernetesClusterFeatureInner createOrUpdate(String resourceGroupName, String kubernetesClusterName, String featureName, KubernetesClusterFeatureInner kubernetesClusterFeatureParameters, String ifMatch, String ifNoneMatch, Context context) {
        return (KubernetesClusterFeatureInner)((Object)this.beginCreateOrUpdate(resourceGroupName, kubernetesClusterName, featureName, kubernetesClusterFeatureParameters, ifMatch, ifNoneMatch, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String kubernetesClusterName, String featureName, String ifMatch, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (featureName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter featureName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, featureName, ifMatch, ifNoneMatch, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String kubernetesClusterName, String featureName, String ifMatch, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (featureName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter featureName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, featureName, ifMatch, ifNoneMatch, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String kubernetesClusterName, String featureName, String ifMatch, String ifNoneMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (featureName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter featureName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, featureName, ifMatch, ifNoneMatch, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDeleteAsync(String resourceGroupName, String kubernetesClusterName, String featureName, String ifMatch, String ifNoneMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, kubernetesClusterName, featureName, ifMatch, ifNoneMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDeleteAsync(String resourceGroupName, String kubernetesClusterName, String featureName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, kubernetesClusterName, featureName, ifMatch, ifNoneMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDelete(String resourceGroupName, String kubernetesClusterName, String featureName, String ifMatch, String ifNoneMatch) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, kubernetesClusterName, featureName, ifMatch, ifNoneMatch);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDelete(String resourceGroupName, String kubernetesClusterName, String featureName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, kubernetesClusterName, featureName, ifMatch, ifNoneMatch);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDelete(String resourceGroupName, String kubernetesClusterName, String featureName, String ifMatch, String ifNoneMatch, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, kubernetesClusterName, featureName, ifMatch, ifNoneMatch, context);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> deleteAsync(String resourceGroupName, String kubernetesClusterName, String featureName, String ifMatch, String ifNoneMatch) {
        return this.beginDeleteAsync(resourceGroupName, kubernetesClusterName, featureName, ifMatch, ifNoneMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> deleteAsync(String resourceGroupName, String kubernetesClusterName, String featureName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return this.beginDeleteAsync(resourceGroupName, kubernetesClusterName, featureName, ifMatch, ifNoneMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner delete(String resourceGroupName, String kubernetesClusterName, String featureName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return (OperationStatusResultInner)this.beginDelete(resourceGroupName, kubernetesClusterName, featureName, ifMatch, ifNoneMatch).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner delete(String resourceGroupName, String kubernetesClusterName, String featureName, String ifMatch, String ifNoneMatch, Context context) {
        return (OperationStatusResultInner)this.beginDelete(resourceGroupName, kubernetesClusterName, featureName, ifMatch, ifNoneMatch, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String kubernetesClusterName, String featureName, String ifMatch, String ifNoneMatch, KubernetesClusterFeaturePatchParameters kubernetesClusterFeatureUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (featureName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter featureName is required and cannot be null."));
        }
        if (kubernetesClusterFeatureUpdateParameters != null) {
            kubernetesClusterFeatureUpdateParameters.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, featureName, ifMatch, ifNoneMatch, kubernetesClusterFeatureUpdateParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String kubernetesClusterName, String featureName, String ifMatch, String ifNoneMatch, KubernetesClusterFeaturePatchParameters kubernetesClusterFeatureUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (featureName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter featureName is required and cannot be null."));
        }
        if (kubernetesClusterFeatureUpdateParameters != null) {
            kubernetesClusterFeatureUpdateParameters.validate();
        }
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, featureName, ifMatch, ifNoneMatch, kubernetesClusterFeatureUpdateParameters, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String kubernetesClusterName, String featureName, String ifMatch, String ifNoneMatch, KubernetesClusterFeaturePatchParameters kubernetesClusterFeatureUpdateParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (featureName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter featureName is required and cannot be null."));
        }
        if (kubernetesClusterFeatureUpdateParameters != null) {
            kubernetesClusterFeatureUpdateParameters.validate();
        }
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, featureName, ifMatch, ifNoneMatch, kubernetesClusterFeatureUpdateParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<KubernetesClusterFeatureInner>, KubernetesClusterFeatureInner> beginUpdateAsync(String resourceGroupName, String kubernetesClusterName, String featureName, String ifMatch, String ifNoneMatch, KubernetesClusterFeaturePatchParameters kubernetesClusterFeatureUpdateParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, kubernetesClusterName, featureName, ifMatch, ifNoneMatch, kubernetesClusterFeatureUpdateParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)KubernetesClusterFeatureInner.class), (Type)((Object)KubernetesClusterFeatureInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<KubernetesClusterFeatureInner>, KubernetesClusterFeatureInner> beginUpdateAsync(String resourceGroupName, String kubernetesClusterName, String featureName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        KubernetesClusterFeaturePatchParameters kubernetesClusterFeatureUpdateParameters = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, kubernetesClusterName, featureName, ifMatch, ifNoneMatch, kubernetesClusterFeatureUpdateParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)KubernetesClusterFeatureInner.class), (Type)((Object)KubernetesClusterFeatureInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<KubernetesClusterFeatureInner>, KubernetesClusterFeatureInner> beginUpdate(String resourceGroupName, String kubernetesClusterName, String featureName, String ifMatch, String ifNoneMatch, KubernetesClusterFeaturePatchParameters kubernetesClusterFeatureUpdateParameters) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, kubernetesClusterName, featureName, ifMatch, ifNoneMatch, kubernetesClusterFeatureUpdateParameters);
        return this.client.getLroResult(response, (Type)((Object)KubernetesClusterFeatureInner.class), (Type)((Object)KubernetesClusterFeatureInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<KubernetesClusterFeatureInner>, KubernetesClusterFeatureInner> beginUpdate(String resourceGroupName, String kubernetesClusterName, String featureName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        KubernetesClusterFeaturePatchParameters kubernetesClusterFeatureUpdateParameters = null;
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, kubernetesClusterName, featureName, ifMatch, ifNoneMatch, kubernetesClusterFeatureUpdateParameters);
        return this.client.getLroResult(response, (Type)((Object)KubernetesClusterFeatureInner.class), (Type)((Object)KubernetesClusterFeatureInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<KubernetesClusterFeatureInner>, KubernetesClusterFeatureInner> beginUpdate(String resourceGroupName, String kubernetesClusterName, String featureName, String ifMatch, String ifNoneMatch, KubernetesClusterFeaturePatchParameters kubernetesClusterFeatureUpdateParameters, Context context) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, kubernetesClusterName, featureName, ifMatch, ifNoneMatch, kubernetesClusterFeatureUpdateParameters, context);
        return this.client.getLroResult(response, (Type)((Object)KubernetesClusterFeatureInner.class), (Type)((Object)KubernetesClusterFeatureInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<KubernetesClusterFeatureInner> updateAsync(String resourceGroupName, String kubernetesClusterName, String featureName, String ifMatch, String ifNoneMatch, KubernetesClusterFeaturePatchParameters kubernetesClusterFeatureUpdateParameters) {
        return this.beginUpdateAsync(resourceGroupName, kubernetesClusterName, featureName, ifMatch, ifNoneMatch, kubernetesClusterFeatureUpdateParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<KubernetesClusterFeatureInner> updateAsync(String resourceGroupName, String kubernetesClusterName, String featureName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        KubernetesClusterFeaturePatchParameters kubernetesClusterFeatureUpdateParameters = null;
        return this.beginUpdateAsync(resourceGroupName, kubernetesClusterName, featureName, ifMatch, ifNoneMatch, kubernetesClusterFeatureUpdateParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public KubernetesClusterFeatureInner update(String resourceGroupName, String kubernetesClusterName, String featureName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        KubernetesClusterFeaturePatchParameters kubernetesClusterFeatureUpdateParameters = null;
        return (KubernetesClusterFeatureInner)((Object)this.beginUpdate(resourceGroupName, kubernetesClusterName, featureName, ifMatch, ifNoneMatch, kubernetesClusterFeatureUpdateParameters).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public KubernetesClusterFeatureInner update(String resourceGroupName, String kubernetesClusterName, String featureName, String ifMatch, String ifNoneMatch, KubernetesClusterFeaturePatchParameters kubernetesClusterFeatureUpdateParameters, Context context) {
        return (KubernetesClusterFeatureInner)((Object)this.beginUpdate(resourceGroupName, kubernetesClusterName, featureName, ifMatch, ifNoneMatch, kubernetesClusterFeatureUpdateParameters, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<KubernetesClusterFeatureInner>> listByKubernetesClusterNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByKubernetesClusterNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KubernetesClusterFeatureList)res.getValue()).value(), ((KubernetesClusterFeatureList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<KubernetesClusterFeatureInner> listByKubernetesClusterNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<KubernetesClusterFeatureList> res = this.service.listByKubernetesClusterNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KubernetesClusterFeatureList)res.getValue()).value(), ((KubernetesClusterFeatureList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<KubernetesClusterFeatureInner> listByKubernetesClusterNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<KubernetesClusterFeatureList> res = this.service.listByKubernetesClusterNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KubernetesClusterFeatureList)res.getValue()).value(), ((KubernetesClusterFeatureList)res.getValue()).nextLink(), null);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkCloudKubernetesClusterFeatures")
    public static interface KubernetesClusterFeaturesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}/features")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<KubernetesClusterFeatureList>> listByKubernetesCluster(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="kubernetesClusterName") String var5, @QueryParam(value="$top") Integer var6, @QueryParam(value="$skipToken") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}/features")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<KubernetesClusterFeatureList> listByKubernetesClusterSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="kubernetesClusterName") String var5, @QueryParam(value="$top") Integer var6, @QueryParam(value="$skipToken") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}/features/{featureName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<KubernetesClusterFeatureInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="kubernetesClusterName") String var5, @PathParam(value="featureName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}/features/{featureName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<KubernetesClusterFeatureInner> getSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="kubernetesClusterName") String var5, @PathParam(value="featureName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}/features/{featureName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="kubernetesClusterName") String var5, @PathParam(value="featureName") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, @BodyParam(value="application/json") KubernetesClusterFeatureInner var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}/features/{featureName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="kubernetesClusterName") String var5, @PathParam(value="featureName") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, @BodyParam(value="application/json") KubernetesClusterFeatureInner var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}/features/{featureName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="kubernetesClusterName") String var5, @PathParam(value="featureName") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}/features/{featureName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="kubernetesClusterName") String var5, @PathParam(value="featureName") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}/features/{featureName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="kubernetesClusterName") String var5, @PathParam(value="featureName") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, @BodyParam(value="application/json") KubernetesClusterFeaturePatchParameters var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}/features/{featureName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> updateSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="kubernetesClusterName") String var5, @PathParam(value="featureName") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, @BodyParam(value="application/json") KubernetesClusterFeaturePatchParameters var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<KubernetesClusterFeatureList>> listByKubernetesClusterNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<KubernetesClusterFeatureList> listByKubernetesClusterNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

