/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.AdministrativeCredentials;
import com.azure.resourcemanager.networkcloud.models.CertificateInfo;
import com.azure.resourcemanager.networkcloud.models.RemoteVendorManagementFeature;
import com.azure.resourcemanager.networkcloud.models.RemoteVendorManagementStatus;
import com.azure.resourcemanager.networkcloud.models.SecretRotationStatus;
import com.azure.resourcemanager.networkcloud.models.StorageApplianceDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.StorageApplianceProvisioningState;
import java.io.IOException;
import java.util.List;

public final class StorageApplianceProperties
implements JsonSerializable<StorageApplianceProperties> {
    private AdministrativeCredentials administratorCredentials;
    private CertificateInfo caCertificate;
    private Long capacity;
    private Long capacityUsed;
    private String clusterId;
    private StorageApplianceDetailedStatus detailedStatus;
    private String detailedStatusMessage;
    private String managementIpv4Address;
    private String manufacturer;
    private String model;
    private StorageApplianceProvisioningState provisioningState;
    private String rackId;
    private long rackSlot;
    private RemoteVendorManagementFeature remoteVendorManagementFeature;
    private RemoteVendorManagementStatus remoteVendorManagementStatus;
    private List<SecretRotationStatus> secretRotationStatus;
    private String serialNumber;
    private String storageApplianceSkuId;
    private String version;
    private static final ClientLogger LOGGER = new ClientLogger(StorageApplianceProperties.class);

    public AdministrativeCredentials administratorCredentials() {
        return this.administratorCredentials;
    }

    public StorageApplianceProperties withAdministratorCredentials(AdministrativeCredentials administratorCredentials) {
        this.administratorCredentials = administratorCredentials;
        return this;
    }

    public CertificateInfo caCertificate() {
        return this.caCertificate;
    }

    public Long capacity() {
        return this.capacity;
    }

    public Long capacityUsed() {
        return this.capacityUsed;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public StorageApplianceDetailedStatus detailedStatus() {
        return this.detailedStatus;
    }

    public String detailedStatusMessage() {
        return this.detailedStatusMessage;
    }

    public String managementIpv4Address() {
        return this.managementIpv4Address;
    }

    public String manufacturer() {
        return this.manufacturer;
    }

    public String model() {
        return this.model;
    }

    public StorageApplianceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String rackId() {
        return this.rackId;
    }

    public StorageApplianceProperties withRackId(String rackId) {
        this.rackId = rackId;
        return this;
    }

    public long rackSlot() {
        return this.rackSlot;
    }

    public StorageApplianceProperties withRackSlot(long rackSlot) {
        this.rackSlot = rackSlot;
        return this;
    }

    public RemoteVendorManagementFeature remoteVendorManagementFeature() {
        return this.remoteVendorManagementFeature;
    }

    public RemoteVendorManagementStatus remoteVendorManagementStatus() {
        return this.remoteVendorManagementStatus;
    }

    public List<SecretRotationStatus> secretRotationStatus() {
        return this.secretRotationStatus;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public StorageApplianceProperties withSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    public String storageApplianceSkuId() {
        return this.storageApplianceSkuId;
    }

    public StorageApplianceProperties withStorageApplianceSkuId(String storageApplianceSkuId) {
        this.storageApplianceSkuId = storageApplianceSkuId;
        return this;
    }

    public String version() {
        return this.version;
    }

    public void validate() {
        if (this.administratorCredentials() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property administratorCredentials in model StorageApplianceProperties"));
        }
        this.administratorCredentials().validate();
        if (this.caCertificate() != null) {
            this.caCertificate().validate();
        }
        if (this.rackId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property rackId in model StorageApplianceProperties"));
        }
        if (this.secretRotationStatus() != null) {
            this.secretRotationStatus().forEach(e -> e.validate());
        }
        if (this.serialNumber() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property serialNumber in model StorageApplianceProperties"));
        }
        if (this.storageApplianceSkuId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property storageApplianceSkuId in model StorageApplianceProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("administratorCredentials", (JsonSerializable)this.administratorCredentials);
        jsonWriter.writeStringField("rackId", this.rackId);
        jsonWriter.writeLongField("rackSlot", this.rackSlot);
        jsonWriter.writeStringField("serialNumber", this.serialNumber);
        jsonWriter.writeStringField("storageApplianceSkuId", this.storageApplianceSkuId);
        return jsonWriter.writeEndObject();
    }

    public static StorageApplianceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (StorageApplianceProperties)jsonReader.readObject(reader -> {
            StorageApplianceProperties deserializedStorageApplianceProperties = new StorageApplianceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("administratorCredentials".equals(fieldName)) {
                    deserializedStorageApplianceProperties.administratorCredentials = AdministrativeCredentials.fromJson(reader);
                    continue;
                }
                if ("rackId".equals(fieldName)) {
                    deserializedStorageApplianceProperties.rackId = reader.getString();
                    continue;
                }
                if ("rackSlot".equals(fieldName)) {
                    deserializedStorageApplianceProperties.rackSlot = reader.getLong();
                    continue;
                }
                if ("serialNumber".equals(fieldName)) {
                    deserializedStorageApplianceProperties.serialNumber = reader.getString();
                    continue;
                }
                if ("storageApplianceSkuId".equals(fieldName)) {
                    deserializedStorageApplianceProperties.storageApplianceSkuId = reader.getString();
                    continue;
                }
                if ("caCertificate".equals(fieldName)) {
                    deserializedStorageApplianceProperties.caCertificate = CertificateInfo.fromJson(reader);
                    continue;
                }
                if ("capacity".equals(fieldName)) {
                    deserializedStorageApplianceProperties.capacity = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("capacityUsed".equals(fieldName)) {
                    deserializedStorageApplianceProperties.capacityUsed = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("clusterId".equals(fieldName)) {
                    deserializedStorageApplianceProperties.clusterId = reader.getString();
                    continue;
                }
                if ("detailedStatus".equals(fieldName)) {
                    deserializedStorageApplianceProperties.detailedStatus = StorageApplianceDetailedStatus.fromString(reader.getString());
                    continue;
                }
                if ("detailedStatusMessage".equals(fieldName)) {
                    deserializedStorageApplianceProperties.detailedStatusMessage = reader.getString();
                    continue;
                }
                if ("managementIpv4Address".equals(fieldName)) {
                    deserializedStorageApplianceProperties.managementIpv4Address = reader.getString();
                    continue;
                }
                if ("manufacturer".equals(fieldName)) {
                    deserializedStorageApplianceProperties.manufacturer = reader.getString();
                    continue;
                }
                if ("model".equals(fieldName)) {
                    deserializedStorageApplianceProperties.model = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedStorageApplianceProperties.provisioningState = StorageApplianceProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("remoteVendorManagementFeature".equals(fieldName)) {
                    deserializedStorageApplianceProperties.remoteVendorManagementFeature = RemoteVendorManagementFeature.fromString(reader.getString());
                    continue;
                }
                if ("remoteVendorManagementStatus".equals(fieldName)) {
                    deserializedStorageApplianceProperties.remoteVendorManagementStatus = RemoteVendorManagementStatus.fromString(reader.getString());
                    continue;
                }
                if ("secretRotationStatus".equals(fieldName)) {
                    List secretRotationStatus;
                    deserializedStorageApplianceProperties.secretRotationStatus = secretRotationStatus = reader.readArray(reader1 -> SecretRotationStatus.fromJson(reader1));
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedStorageApplianceProperties.version = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageApplianceProperties;
        });
    }
}

