/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.ConsoleProperties;
import com.azure.resourcemanager.networkcloud.models.ConsoleDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.ConsoleEnabled;
import com.azure.resourcemanager.networkcloud.models.ConsoleProvisioningState;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.SshPublicKey;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class ConsoleInner
extends Resource {
    private String etag;
    private ExtendedLocation extendedLocation;
    private ConsoleProperties innerProperties = new ConsoleProperties();
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(ConsoleInner.class);

    public String etag() {
        return this.etag;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public ConsoleInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    private ConsoleProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ConsoleInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ConsoleInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ConsoleDetailedStatus detailedStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatus();
    }

    public String detailedStatusMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatusMessage();
    }

    public ConsoleEnabled enabled() {
        return this.innerProperties() == null ? null : this.innerProperties().enabled();
    }

    public ConsoleInner withEnabled(ConsoleEnabled enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConsoleProperties();
        }
        this.innerProperties().withEnabled(enabled);
        return this;
    }

    public OffsetDateTime expiration() {
        return this.innerProperties() == null ? null : this.innerProperties().expiration();
    }

    public ConsoleInner withExpiration(OffsetDateTime expiration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConsoleProperties();
        }
        this.innerProperties().withExpiration(expiration);
        return this;
    }

    public String privateLinkServiceId() {
        return this.innerProperties() == null ? null : this.innerProperties().privateLinkServiceId();
    }

    public ConsoleProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public SshPublicKey sshPublicKey() {
        return this.innerProperties() == null ? null : this.innerProperties().sshPublicKey();
    }

    public ConsoleInner withSshPublicKey(SshPublicKey sshPublicKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConsoleProperties();
        }
        this.innerProperties().withSshPublicKey(sshPublicKey);
        return this;
    }

    public String virtualMachineAccessId() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualMachineAccessId();
    }

    public void validate() {
        if (this.extendedLocation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property extendedLocation in model ConsoleInner"));
        }
        this.extendedLocation().validate();
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model ConsoleInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ConsoleInner fromJson(JsonReader jsonReader) throws IOException {
        return (ConsoleInner)((Object)jsonReader.readObject(reader -> {
            ConsoleInner deserializedConsoleInner = new ConsoleInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedConsoleInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedConsoleInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedConsoleInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedConsoleInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedConsoleInner.withTags(tags);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedConsoleInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedConsoleInner.innerProperties = ConsoleProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedConsoleInner.etag = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedConsoleInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConsoleInner;
        }));
    }
}

