/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.CloudServicesNetworkEnableDefaultEgressEndpoints;
import com.azure.resourcemanager.networkcloud.models.CloudServicesNetworkStorageOptionsPatch;
import com.azure.resourcemanager.networkcloud.models.EgressEndpoint;
import java.io.IOException;
import java.util.List;

public final class CloudServicesNetworkPatchProperties
implements JsonSerializable<CloudServicesNetworkPatchProperties> {
    private List<EgressEndpoint> additionalEgressEndpoints;
    private CloudServicesNetworkEnableDefaultEgressEndpoints enableDefaultEgressEndpoints;
    private CloudServicesNetworkStorageOptionsPatch storageOptions;

    public List<EgressEndpoint> additionalEgressEndpoints() {
        return this.additionalEgressEndpoints;
    }

    public CloudServicesNetworkPatchProperties withAdditionalEgressEndpoints(List<EgressEndpoint> additionalEgressEndpoints) {
        this.additionalEgressEndpoints = additionalEgressEndpoints;
        return this;
    }

    public CloudServicesNetworkEnableDefaultEgressEndpoints enableDefaultEgressEndpoints() {
        return this.enableDefaultEgressEndpoints;
    }

    public CloudServicesNetworkPatchProperties withEnableDefaultEgressEndpoints(CloudServicesNetworkEnableDefaultEgressEndpoints enableDefaultEgressEndpoints) {
        this.enableDefaultEgressEndpoints = enableDefaultEgressEndpoints;
        return this;
    }

    public CloudServicesNetworkStorageOptionsPatch storageOptions() {
        return this.storageOptions;
    }

    public CloudServicesNetworkPatchProperties withStorageOptions(CloudServicesNetworkStorageOptionsPatch storageOptions) {
        this.storageOptions = storageOptions;
        return this;
    }

    public void validate() {
        if (this.additionalEgressEndpoints() != null) {
            this.additionalEgressEndpoints().forEach(e -> e.validate());
        }
        if (this.storageOptions() != null) {
            this.storageOptions().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("additionalEgressEndpoints", this.additionalEgressEndpoints, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("enableDefaultEgressEndpoints", this.enableDefaultEgressEndpoints == null ? null : this.enableDefaultEgressEndpoints.toString());
        jsonWriter.writeJsonField("storageOptions", (JsonSerializable)this.storageOptions);
        return jsonWriter.writeEndObject();
    }

    public static CloudServicesNetworkPatchProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CloudServicesNetworkPatchProperties)jsonReader.readObject(reader -> {
            CloudServicesNetworkPatchProperties deserializedCloudServicesNetworkPatchProperties = new CloudServicesNetworkPatchProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("additionalEgressEndpoints".equals(fieldName)) {
                    List additionalEgressEndpoints;
                    deserializedCloudServicesNetworkPatchProperties.additionalEgressEndpoints = additionalEgressEndpoints = reader.readArray(reader1 -> EgressEndpoint.fromJson(reader1));
                    continue;
                }
                if ("enableDefaultEgressEndpoints".equals(fieldName)) {
                    deserializedCloudServicesNetworkPatchProperties.enableDefaultEgressEndpoints = CloudServicesNetworkEnableDefaultEgressEndpoints.fromString(reader.getString());
                    continue;
                }
                if ("storageOptions".equals(fieldName)) {
                    deserializedCloudServicesNetworkPatchProperties.storageOptions = CloudServicesNetworkStorageOptionsPatch.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCloudServicesNetworkPatchProperties;
        });
    }
}

