/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.AgentPoolProperties;
import com.azure.resourcemanager.networkcloud.models.AdministratorConfiguration;
import com.azure.resourcemanager.networkcloud.models.AgentOptions;
import com.azure.resourcemanager.networkcloud.models.AgentPoolDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.AgentPoolMode;
import com.azure.resourcemanager.networkcloud.models.AgentPoolProvisioningState;
import com.azure.resourcemanager.networkcloud.models.AgentPoolUpgradeSettings;
import com.azure.resourcemanager.networkcloud.models.AttachedNetworkConfiguration;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.KubernetesLabel;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class AgentPoolInner
extends Resource {
    private String etag;
    private ExtendedLocation extendedLocation;
    private AgentPoolProperties innerProperties = new AgentPoolProperties();
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(AgentPoolInner.class);

    public String etag() {
        return this.etag;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public AgentPoolInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    private AgentPoolProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public AgentPoolInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public AgentPoolInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public AdministratorConfiguration administratorConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorConfiguration();
    }

    public AgentPoolInner withAdministratorConfiguration(AdministratorConfiguration administratorConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AgentPoolProperties();
        }
        this.innerProperties().withAdministratorConfiguration(administratorConfiguration);
        return this;
    }

    public AgentOptions agentOptions() {
        return this.innerProperties() == null ? null : this.innerProperties().agentOptions();
    }

    public AgentPoolInner withAgentOptions(AgentOptions agentOptions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AgentPoolProperties();
        }
        this.innerProperties().withAgentOptions(agentOptions);
        return this;
    }

    public AttachedNetworkConfiguration attachedNetworkConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().attachedNetworkConfiguration();
    }

    public AgentPoolInner withAttachedNetworkConfiguration(AttachedNetworkConfiguration attachedNetworkConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AgentPoolProperties();
        }
        this.innerProperties().withAttachedNetworkConfiguration(attachedNetworkConfiguration);
        return this;
    }

    public List<String> availabilityZones() {
        return this.innerProperties() == null ? null : this.innerProperties().availabilityZones();
    }

    public AgentPoolInner withAvailabilityZones(List<String> availabilityZones) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AgentPoolProperties();
        }
        this.innerProperties().withAvailabilityZones(availabilityZones);
        return this;
    }

    public long count() {
        return this.innerProperties() == null ? 0L : this.innerProperties().count();
    }

    public AgentPoolInner withCount(long count) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AgentPoolProperties();
        }
        this.innerProperties().withCount(count);
        return this;
    }

    public AgentPoolDetailedStatus detailedStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatus();
    }

    public String detailedStatusMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatusMessage();
    }

    public String kubernetesVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().kubernetesVersion();
    }

    public List<KubernetesLabel> labels() {
        return this.innerProperties() == null ? null : this.innerProperties().labels();
    }

    public AgentPoolInner withLabels(List<KubernetesLabel> labels) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AgentPoolProperties();
        }
        this.innerProperties().withLabels(labels);
        return this;
    }

    public AgentPoolMode mode() {
        return this.innerProperties() == null ? null : this.innerProperties().mode();
    }

    public AgentPoolInner withMode(AgentPoolMode mode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AgentPoolProperties();
        }
        this.innerProperties().withMode(mode);
        return this;
    }

    public AgentPoolProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public List<KubernetesLabel> taints() {
        return this.innerProperties() == null ? null : this.innerProperties().taints();
    }

    public AgentPoolInner withTaints(List<KubernetesLabel> taints) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AgentPoolProperties();
        }
        this.innerProperties().withTaints(taints);
        return this;
    }

    public AgentPoolUpgradeSettings upgradeSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().upgradeSettings();
    }

    public AgentPoolInner withUpgradeSettings(AgentPoolUpgradeSettings upgradeSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AgentPoolProperties();
        }
        this.innerProperties().withUpgradeSettings(upgradeSettings);
        return this;
    }

    public String vmSkuName() {
        return this.innerProperties() == null ? null : this.innerProperties().vmSkuName();
    }

    public AgentPoolInner withVmSkuName(String vmSkuName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AgentPoolProperties();
        }
        this.innerProperties().withVmSkuName(vmSkuName);
        return this;
    }

    public void validate() {
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model AgentPoolInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        return jsonWriter.writeEndObject();
    }

    public static AgentPoolInner fromJson(JsonReader jsonReader) throws IOException {
        return (AgentPoolInner)((Object)jsonReader.readObject(reader -> {
            AgentPoolInner deserializedAgentPoolInner = new AgentPoolInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAgentPoolInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAgentPoolInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAgentPoolInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedAgentPoolInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAgentPoolInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAgentPoolInner.innerProperties = AgentPoolProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedAgentPoolInner.etag = reader.getString();
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedAgentPoolInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedAgentPoolInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAgentPoolInner;
        }));
    }
}

