/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.fluent.models.VirtualMachineInner;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.ImageRepositoryCredentials;
import com.azure.resourcemanager.networkcloud.models.NetworkAttachment;
import com.azure.resourcemanager.networkcloud.models.OperationStatusResult;
import com.azure.resourcemanager.networkcloud.models.SshPublicKey;
import com.azure.resourcemanager.networkcloud.models.StorageProfile;
import com.azure.resourcemanager.networkcloud.models.VirtualMachineBootMethod;
import com.azure.resourcemanager.networkcloud.models.VirtualMachineDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.VirtualMachineDeviceModelType;
import com.azure.resourcemanager.networkcloud.models.VirtualMachineIsolateEmulatorThread;
import com.azure.resourcemanager.networkcloud.models.VirtualMachinePlacementHint;
import com.azure.resourcemanager.networkcloud.models.VirtualMachinePowerOffParameters;
import com.azure.resourcemanager.networkcloud.models.VirtualMachinePowerState;
import com.azure.resourcemanager.networkcloud.models.VirtualMachineProvisioningState;
import com.azure.resourcemanager.networkcloud.models.VirtualMachineVirtioInterfaceType;
import java.util.List;
import java.util.Map;

public interface VirtualMachine {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public String etag();

    public ExtendedLocation extendedLocation();

    public SystemData systemData();

    public String adminUsername();

    public String availabilityZone();

    public String bareMetalMachineId();

    public VirtualMachineBootMethod bootMethod();

    public NetworkAttachment cloudServicesNetworkAttachment();

    public String clusterId();

    public ExtendedLocation consoleExtendedLocation();

    public long cpuCores();

    public VirtualMachineDetailedStatus detailedStatus();

    public String detailedStatusMessage();

    public VirtualMachineIsolateEmulatorThread isolateEmulatorThread();

    public long memorySizeGB();

    public List<NetworkAttachment> networkAttachments();

    public String networkData();

    public List<VirtualMachinePlacementHint> placementHints();

    public VirtualMachinePowerState powerState();

    public VirtualMachineProvisioningState provisioningState();

    public List<SshPublicKey> sshPublicKeys();

    public StorageProfile storageProfile();

    public String userData();

    public VirtualMachineVirtioInterfaceType virtioInterface();

    public VirtualMachineDeviceModelType vmDeviceModel();

    public String vmImage();

    public ImageRepositoryCredentials vmImageRepositoryCredentials();

    public List<String> volumes();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public VirtualMachineInner innerModel();

    public Update update();

    public VirtualMachine refresh();

    public VirtualMachine refresh(Context var1);

    public OperationStatusResult powerOff();

    public OperationStatusResult powerOff(VirtualMachinePowerOffParameters var1, Context var2);

    public OperationStatusResult reimage();

    public OperationStatusResult reimage(Context var1);

    public OperationStatusResult restart();

    public OperationStatusResult restart(Context var1);

    public OperationStatusResult start();

    public OperationStatusResult start(Context var1);

    public static interface UpdateStages {

        public static interface WithIfNoneMatch {
            public Update withIfNoneMatch(String var1);
        }

        public static interface WithIfMatch {
            public Update withIfMatch(String var1);
        }

        public static interface WithVmImageRepositoryCredentials {
            public Update withVmImageRepositoryCredentials(ImageRepositoryCredentials var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithVmImageRepositoryCredentials,
    UpdateStages.WithIfMatch,
    UpdateStages.WithIfNoneMatch {
        public VirtualMachine apply();

        public VirtualMachine apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIfNoneMatch {
            public WithCreate withIfNoneMatch(String var1);
        }

        public static interface WithIfMatch {
            public WithCreate withIfMatch(String var1);
        }

        public static interface WithVmImageRepositoryCredentials {
            public WithCreate withVmImageRepositoryCredentials(ImageRepositoryCredentials var1);
        }

        public static interface WithVmDeviceModel {
            public WithCreate withVmDeviceModel(VirtualMachineDeviceModelType var1);
        }

        public static interface WithVirtioInterface {
            public WithCreate withVirtioInterface(VirtualMachineVirtioInterfaceType var1);
        }

        public static interface WithUserData {
            public WithCreate withUserData(String var1);
        }

        public static interface WithSshPublicKeys {
            public WithCreate withSshPublicKeys(List<SshPublicKey> var1);
        }

        public static interface WithPlacementHints {
            public WithCreate withPlacementHints(List<VirtualMachinePlacementHint> var1);
        }

        public static interface WithNetworkData {
            public WithCreate withNetworkData(String var1);
        }

        public static interface WithNetworkAttachments {
            public WithCreate withNetworkAttachments(List<NetworkAttachment> var1);
        }

        public static interface WithIsolateEmulatorThread {
            public WithCreate withIsolateEmulatorThread(VirtualMachineIsolateEmulatorThread var1);
        }

        public static interface WithConsoleExtendedLocation {
            public WithCreate withConsoleExtendedLocation(ExtendedLocation var1);
        }

        public static interface WithBootMethod {
            public WithCreate withBootMethod(VirtualMachineBootMethod var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithBootMethod,
        WithConsoleExtendedLocation,
        WithIsolateEmulatorThread,
        WithNetworkAttachments,
        WithNetworkData,
        WithPlacementHints,
        WithSshPublicKeys,
        WithUserData,
        WithVirtioInterface,
        WithVmDeviceModel,
        WithVmImageRepositoryCredentials,
        WithIfMatch,
        WithIfNoneMatch {
            public VirtualMachine create();

            public VirtualMachine create(Context var1);
        }

        public static interface WithVmImage {
            public WithCreate withVmImage(String var1);
        }

        public static interface WithStorageProfile {
            public WithVmImage withStorageProfile(StorageProfile var1);
        }

        public static interface WithMemorySizeGB {
            public WithStorageProfile withMemorySizeGB(long var1);
        }

        public static interface WithCpuCores {
            public WithMemorySizeGB withCpuCores(long var1);
        }

        public static interface WithCloudServicesNetworkAttachment {
            public WithCpuCores withCloudServicesNetworkAttachment(NetworkAttachment var1);
        }

        public static interface WithAdminUsername {
            public WithCloudServicesNetworkAttachment withAdminUsername(String var1);
        }

        public static interface WithExtendedLocation {
            public WithAdminUsername withExtendedLocation(ExtendedLocation var1);
        }

        public static interface WithResourceGroup {
            public WithExtendedLocation withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithExtendedLocation,
    DefinitionStages.WithAdminUsername,
    DefinitionStages.WithCloudServicesNetworkAttachment,
    DefinitionStages.WithCpuCores,
    DefinitionStages.WithMemorySizeGB,
    DefinitionStages.WithStorageProfile,
    DefinitionStages.WithVmImage,
    DefinitionStages.WithCreate {
    }
}

