/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.StorageAppliancePatchProperties;
import java.io.IOException;
import java.util.Map;

public final class StorageAppliancePatchParameters
implements JsonSerializable<StorageAppliancePatchParameters> {
    private StorageAppliancePatchProperties innerProperties;
    private Map<String, String> tags;

    private StorageAppliancePatchProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public StorageAppliancePatchParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String serialNumber() {
        return this.innerProperties() == null ? null : this.innerProperties().serialNumber();
    }

    public StorageAppliancePatchParameters withSerialNumber(String serialNumber) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAppliancePatchProperties();
        }
        this.innerProperties().withSerialNumber(serialNumber);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static StorageAppliancePatchParameters fromJson(JsonReader jsonReader) throws IOException {
        return (StorageAppliancePatchParameters)jsonReader.readObject(reader -> {
            StorageAppliancePatchParameters deserializedStorageAppliancePatchParameters = new StorageAppliancePatchParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedStorageAppliancePatchParameters.innerProperties = StorageAppliancePatchProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedStorageAppliancePatchParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageAppliancePatchParameters;
        });
    }
}

