/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.ManagedServiceIdentitySelectorType;
import java.io.IOException;

public final class IdentitySelector
implements JsonSerializable<IdentitySelector> {
    private ManagedServiceIdentitySelectorType identityType;
    private String userAssignedIdentityResourceId;

    public ManagedServiceIdentitySelectorType identityType() {
        return this.identityType;
    }

    public IdentitySelector withIdentityType(ManagedServiceIdentitySelectorType identityType) {
        this.identityType = identityType;
        return this;
    }

    public String userAssignedIdentityResourceId() {
        return this.userAssignedIdentityResourceId;
    }

    public IdentitySelector withUserAssignedIdentityResourceId(String userAssignedIdentityResourceId) {
        this.userAssignedIdentityResourceId = userAssignedIdentityResourceId;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("identityType", this.identityType == null ? null : this.identityType.toString());
        jsonWriter.writeStringField("userAssignedIdentityResourceId", this.userAssignedIdentityResourceId);
        return jsonWriter.writeEndObject();
    }

    public static IdentitySelector fromJson(JsonReader jsonReader) throws IOException {
        return (IdentitySelector)jsonReader.readObject(reader -> {
            IdentitySelector deserializedIdentitySelector = new IdentitySelector();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("identityType".equals(fieldName)) {
                    deserializedIdentitySelector.identityType = ManagedServiceIdentitySelectorType.fromString(reader.getString());
                    continue;
                }
                if ("userAssignedIdentityResourceId".equals(fieldName)) {
                    deserializedIdentitySelector.userAssignedIdentityResourceId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIdentitySelector;
        });
    }
}

