/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.EndpointDependency;
import java.io.IOException;
import java.util.List;

public final class EgressEndpoint
implements JsonSerializable<EgressEndpoint> {
    private String category;
    private List<EndpointDependency> endpoints;
    private static final ClientLogger LOGGER = new ClientLogger(EgressEndpoint.class);

    public String category() {
        return this.category;
    }

    public EgressEndpoint withCategory(String category) {
        this.category = category;
        return this;
    }

    public List<EndpointDependency> endpoints() {
        return this.endpoints;
    }

    public EgressEndpoint withEndpoints(List<EndpointDependency> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public void validate() {
        if (this.category() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property category in model EgressEndpoint"));
        }
        if (this.endpoints() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property endpoints in model EgressEndpoint"));
        }
        this.endpoints().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("category", this.category);
        jsonWriter.writeArrayField("endpoints", this.endpoints, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static EgressEndpoint fromJson(JsonReader jsonReader) throws IOException {
        return (EgressEndpoint)jsonReader.readObject(reader -> {
            EgressEndpoint deserializedEgressEndpoint = new EgressEndpoint();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("category".equals(fieldName)) {
                    deserializedEgressEndpoint.category = reader.getString();
                    continue;
                }
                if ("endpoints".equals(fieldName)) {
                    List endpoints;
                    deserializedEgressEndpoint.endpoints = endpoints = reader.readArray(reader1 -> EndpointDependency.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEgressEndpoint;
        });
    }
}

