/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.ConsolePatchProperties;
import com.azure.resourcemanager.networkcloud.models.ConsoleEnabled;
import com.azure.resourcemanager.networkcloud.models.SshPublicKey;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class ConsolePatchParameters
implements JsonSerializable<ConsolePatchParameters> {
    private ConsolePatchProperties innerProperties;
    private Map<String, String> tags;

    private ConsolePatchProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ConsolePatchParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public ConsoleEnabled enabled() {
        return this.innerProperties() == null ? null : this.innerProperties().enabled();
    }

    public ConsolePatchParameters withEnabled(ConsoleEnabled enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConsolePatchProperties();
        }
        this.innerProperties().withEnabled(enabled);
        return this;
    }

    public OffsetDateTime expiration() {
        return this.innerProperties() == null ? null : this.innerProperties().expiration();
    }

    public ConsolePatchParameters withExpiration(OffsetDateTime expiration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConsolePatchProperties();
        }
        this.innerProperties().withExpiration(expiration);
        return this;
    }

    public SshPublicKey sshPublicKey() {
        return this.innerProperties() == null ? null : this.innerProperties().sshPublicKey();
    }

    public ConsolePatchParameters withSshPublicKey(SshPublicKey sshPublicKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConsolePatchProperties();
        }
        this.innerProperties().withSshPublicKey(sshPublicKey);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ConsolePatchParameters fromJson(JsonReader jsonReader) throws IOException {
        return (ConsolePatchParameters)jsonReader.readObject(reader -> {
            ConsolePatchParameters deserializedConsolePatchParameters = new ConsolePatchParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedConsolePatchParameters.innerProperties = ConsolePatchProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedConsolePatchParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConsolePatchParameters;
        });
    }
}

