/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.CloudServicesNetworkInner;
import java.io.IOException;
import java.util.List;

public final class CloudServicesNetworkList
implements JsonSerializable<CloudServicesNetworkList> {
    private String nextLink;
    private List<CloudServicesNetworkInner> value;

    public String nextLink() {
        return this.nextLink;
    }

    public CloudServicesNetworkList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public List<CloudServicesNetworkInner> value() {
        return this.value;
    }

    public CloudServicesNetworkList withValue(List<CloudServicesNetworkInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static CloudServicesNetworkList fromJson(JsonReader jsonReader) throws IOException {
        return (CloudServicesNetworkList)jsonReader.readObject(reader -> {
            CloudServicesNetworkList deserializedCloudServicesNetworkList = new CloudServicesNetworkList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedCloudServicesNetworkList.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedCloudServicesNetworkList.value = value = reader.readArray(reader1 -> CloudServicesNetworkInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCloudServicesNetworkList;
        });
    }
}

