/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.BmcKeySetInner;
import java.io.IOException;
import java.util.List;

public final class BmcKeySetList
implements JsonSerializable<BmcKeySetList> {
    private String nextLink;
    private List<BmcKeySetInner> value;

    public String nextLink() {
        return this.nextLink;
    }

    public BmcKeySetList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public List<BmcKeySetInner> value() {
        return this.value;
    }

    public BmcKeySetList withValue(List<BmcKeySetInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BmcKeySetList fromJson(JsonReader jsonReader) throws IOException {
        return (BmcKeySetList)jsonReader.readObject(reader -> {
            BmcKeySetList deserializedBmcKeySetList = new BmcKeySetList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedBmcKeySetList.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedBmcKeySetList.value = value = reader.readArray(reader1 -> BmcKeySetInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBmcKeySetList;
        });
    }
}

