/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.BgpAdvertisement;
import com.azure.resourcemanager.networkcloud.models.FabricPeeringEnabled;
import com.azure.resourcemanager.networkcloud.models.IpAddressPool;
import com.azure.resourcemanager.networkcloud.models.ServiceLoadBalancerBgpPeer;
import java.io.IOException;
import java.util.List;

public final class BgpServiceLoadBalancerConfiguration
implements JsonSerializable<BgpServiceLoadBalancerConfiguration> {
    private List<BgpAdvertisement> bgpAdvertisements;
    private List<ServiceLoadBalancerBgpPeer> bgpPeers;
    private FabricPeeringEnabled fabricPeeringEnabled;
    private List<IpAddressPool> ipAddressPools;

    public List<BgpAdvertisement> bgpAdvertisements() {
        return this.bgpAdvertisements;
    }

    public BgpServiceLoadBalancerConfiguration withBgpAdvertisements(List<BgpAdvertisement> bgpAdvertisements) {
        this.bgpAdvertisements = bgpAdvertisements;
        return this;
    }

    public List<ServiceLoadBalancerBgpPeer> bgpPeers() {
        return this.bgpPeers;
    }

    public BgpServiceLoadBalancerConfiguration withBgpPeers(List<ServiceLoadBalancerBgpPeer> bgpPeers) {
        this.bgpPeers = bgpPeers;
        return this;
    }

    public FabricPeeringEnabled fabricPeeringEnabled() {
        return this.fabricPeeringEnabled;
    }

    public BgpServiceLoadBalancerConfiguration withFabricPeeringEnabled(FabricPeeringEnabled fabricPeeringEnabled) {
        this.fabricPeeringEnabled = fabricPeeringEnabled;
        return this;
    }

    public List<IpAddressPool> ipAddressPools() {
        return this.ipAddressPools;
    }

    public BgpServiceLoadBalancerConfiguration withIpAddressPools(List<IpAddressPool> ipAddressPools) {
        this.ipAddressPools = ipAddressPools;
        return this;
    }

    public void validate() {
        if (this.bgpAdvertisements() != null) {
            this.bgpAdvertisements().forEach(e -> e.validate());
        }
        if (this.bgpPeers() != null) {
            this.bgpPeers().forEach(e -> e.validate());
        }
        if (this.ipAddressPools() != null) {
            this.ipAddressPools().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("bgpAdvertisements", this.bgpAdvertisements, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("bgpPeers", this.bgpPeers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("fabricPeeringEnabled", this.fabricPeeringEnabled == null ? null : this.fabricPeeringEnabled.toString());
        jsonWriter.writeArrayField("ipAddressPools", this.ipAddressPools, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BgpServiceLoadBalancerConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (BgpServiceLoadBalancerConfiguration)jsonReader.readObject(reader -> {
            BgpServiceLoadBalancerConfiguration deserializedBgpServiceLoadBalancerConfiguration = new BgpServiceLoadBalancerConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("bgpAdvertisements".equals(fieldName)) {
                    List bgpAdvertisements;
                    deserializedBgpServiceLoadBalancerConfiguration.bgpAdvertisements = bgpAdvertisements = reader.readArray(reader1 -> BgpAdvertisement.fromJson(reader1));
                    continue;
                }
                if ("bgpPeers".equals(fieldName)) {
                    List bgpPeers;
                    deserializedBgpServiceLoadBalancerConfiguration.bgpPeers = bgpPeers = reader.readArray(reader1 -> ServiceLoadBalancerBgpPeer.fromJson(reader1));
                    continue;
                }
                if ("fabricPeeringEnabled".equals(fieldName)) {
                    deserializedBgpServiceLoadBalancerConfiguration.fabricPeeringEnabled = FabricPeeringEnabled.fromString(reader.getString());
                    continue;
                }
                if ("ipAddressPools".equals(fieldName)) {
                    List ipAddressPools;
                    deserializedBgpServiceLoadBalancerConfiguration.ipAddressPools = ipAddressPools = reader.readArray(reader1 -> IpAddressPool.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBgpServiceLoadBalancerConfiguration;
        });
    }
}

