/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineCommandSpecification;
import java.io.IOException;
import java.util.List;

public final class BareMetalMachineRunDataExtractsParameters
implements JsonSerializable<BareMetalMachineRunDataExtractsParameters> {
    private List<BareMetalMachineCommandSpecification> commands;
    private long limitTimeSeconds;
    private static final ClientLogger LOGGER = new ClientLogger(BareMetalMachineRunDataExtractsParameters.class);

    public List<BareMetalMachineCommandSpecification> commands() {
        return this.commands;
    }

    public BareMetalMachineRunDataExtractsParameters withCommands(List<BareMetalMachineCommandSpecification> commands) {
        this.commands = commands;
        return this;
    }

    public long limitTimeSeconds() {
        return this.limitTimeSeconds;
    }

    public BareMetalMachineRunDataExtractsParameters withLimitTimeSeconds(long limitTimeSeconds) {
        this.limitTimeSeconds = limitTimeSeconds;
        return this;
    }

    public void validate() {
        if (this.commands() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property commands in model BareMetalMachineRunDataExtractsParameters"));
        }
        this.commands().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("commands", this.commands, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeLongField("limitTimeSeconds", this.limitTimeSeconds);
        return jsonWriter.writeEndObject();
    }

    public static BareMetalMachineRunDataExtractsParameters fromJson(JsonReader jsonReader) throws IOException {
        return (BareMetalMachineRunDataExtractsParameters)jsonReader.readObject(reader -> {
            BareMetalMachineRunDataExtractsParameters deserializedBareMetalMachineRunDataExtractsParameters = new BareMetalMachineRunDataExtractsParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("commands".equals(fieldName)) {
                    List commands;
                    deserializedBareMetalMachineRunDataExtractsParameters.commands = commands = reader.readArray(reader1 -> BareMetalMachineCommandSpecification.fromJson(reader1));
                    continue;
                }
                if ("limitTimeSeconds".equals(fieldName)) {
                    deserializedBareMetalMachineRunDataExtractsParameters.limitTimeSeconds = reader.getLong();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBareMetalMachineRunDataExtractsParameters;
        });
    }
}

