/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.BareMetalMachineKeySetPatchProperties;
import com.azure.resourcemanager.networkcloud.models.KeySetUser;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class BareMetalMachineKeySetPatchParameters
implements JsonSerializable<BareMetalMachineKeySetPatchParameters> {
    private BareMetalMachineKeySetPatchProperties innerProperties;
    private Map<String, String> tags;

    private BareMetalMachineKeySetPatchProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public BareMetalMachineKeySetPatchParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public OffsetDateTime expiration() {
        return this.innerProperties() == null ? null : this.innerProperties().expiration();
    }

    public BareMetalMachineKeySetPatchParameters withExpiration(OffsetDateTime expiration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BareMetalMachineKeySetPatchProperties();
        }
        this.innerProperties().withExpiration(expiration);
        return this;
    }

    public List<String> jumpHostsAllowed() {
        return this.innerProperties() == null ? null : this.innerProperties().jumpHostsAllowed();
    }

    public BareMetalMachineKeySetPatchParameters withJumpHostsAllowed(List<String> jumpHostsAllowed) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BareMetalMachineKeySetPatchProperties();
        }
        this.innerProperties().withJumpHostsAllowed(jumpHostsAllowed);
        return this;
    }

    public List<KeySetUser> userList() {
        return this.innerProperties() == null ? null : this.innerProperties().userList();
    }

    public BareMetalMachineKeySetPatchParameters withUserList(List<KeySetUser> userList) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BareMetalMachineKeySetPatchProperties();
        }
        this.innerProperties().withUserList(userList);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static BareMetalMachineKeySetPatchParameters fromJson(JsonReader jsonReader) throws IOException {
        return (BareMetalMachineKeySetPatchParameters)jsonReader.readObject(reader -> {
            BareMetalMachineKeySetPatchParameters deserializedBareMetalMachineKeySetPatchParameters = new BareMetalMachineKeySetPatchParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedBareMetalMachineKeySetPatchParameters.innerProperties = BareMetalMachineKeySetPatchProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedBareMetalMachineKeySetPatchParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBareMetalMachineKeySetPatchParameters;
        });
    }
}

