/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.RacksClient;
import com.azure.resourcemanager.networkcloud.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.networkcloud.fluent.models.RackInner;
import com.azure.resourcemanager.networkcloud.implementation.OperationStatusResultImpl;
import com.azure.resourcemanager.networkcloud.implementation.RackImpl;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.models.OperationStatusResult;
import com.azure.resourcemanager.networkcloud.models.Rack;
import com.azure.resourcemanager.networkcloud.models.Racks;

public final class RacksImpl
implements Racks {
    private static final ClientLogger LOGGER = new ClientLogger(RacksImpl.class);
    private final RacksClient innerClient;
    private final NetworkCloudManager serviceManager;

    public RacksImpl(RacksClient innerClient, NetworkCloudManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Rack> list() {
        PagedIterable<RackInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RackImpl((RackInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Rack> list(Context context) {
        PagedIterable<RackInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RackImpl((RackInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Rack> listByResourceGroup(String resourceGroupName) {
        PagedIterable<RackInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RackImpl((RackInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Rack> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<RackInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RackImpl((RackInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Rack> getByResourceGroupWithResponse(String resourceGroupName, String rackName, Context context) {
        Response<RackInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, rackName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RackImpl((RackInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Rack getByResourceGroup(String resourceGroupName, String rackName) {
        RackInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, rackName);
        if (inner != null) {
            return new RackImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult deleteByResourceGroup(String resourceGroupName, String rackName) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, rackName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult delete(String resourceGroupName, String rackName, String ifMatch, String ifNoneMatch, Context context) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, rackName, ifMatch, ifNoneMatch, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Rack getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String rackName = ResourceManagerUtils.getValueFromIdByName(id, "racks");
        if (rackName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'racks'.", id)));
        }
        return (Rack)this.getByResourceGroupWithResponse(resourceGroupName, rackName, Context.NONE).getValue();
    }

    @Override
    public Response<Rack> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String rackName = ResourceManagerUtils.getValueFromIdByName(id, "racks");
        if (rackName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'racks'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, rackName, context);
    }

    @Override
    public OperationStatusResult deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String rackName = ResourceManagerUtils.getValueFromIdByName(id, "racks");
        if (rackName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'racks'.", id)));
        }
        String localIfMatch = null;
        String localIfNoneMatch = null;
        return this.delete(resourceGroupName, rackName, localIfMatch, localIfNoneMatch, Context.NONE);
    }

    @Override
    public OperationStatusResult deleteByIdWithResponse(String id, String ifMatch, String ifNoneMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String rackName = ResourceManagerUtils.getValueFromIdByName(id, "racks");
        if (rackName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'racks'.", id)));
        }
        return this.delete(resourceGroupName, rackName, ifMatch, ifNoneMatch, context);
    }

    private RacksClient serviceClient() {
        return this.innerClient;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public RackImpl define(String name) {
        return new RackImpl(name, this.manager());
    }
}

