/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.models.ConsoleInner;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.models.Console;
import com.azure.resourcemanager.networkcloud.models.ConsoleDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.ConsoleEnabled;
import com.azure.resourcemanager.networkcloud.models.ConsolePatchParameters;
import com.azure.resourcemanager.networkcloud.models.ConsoleProvisioningState;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.SshPublicKey;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Map;

public final class ConsoleImpl
implements Console,
Console.Definition,
Console.Update {
    private ConsoleInner innerObject;
    private final NetworkCloudManager serviceManager;
    private String resourceGroupName;
    private String virtualMachineName;
    private String consoleName;
    private String createIfMatch;
    private String createIfNoneMatch;
    private String updateIfMatch;
    private String updateIfNoneMatch;
    private ConsolePatchParameters updateConsoleUpdateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public ConsoleDetailedStatus detailedStatus() {
        return this.innerModel().detailedStatus();
    }

    @Override
    public String detailedStatusMessage() {
        return this.innerModel().detailedStatusMessage();
    }

    @Override
    public ConsoleEnabled enabled() {
        return this.innerModel().enabled();
    }

    @Override
    public OffsetDateTime expiration() {
        return this.innerModel().expiration();
    }

    @Override
    public String privateLinkServiceId() {
        return this.innerModel().privateLinkServiceId();
    }

    @Override
    public ConsoleProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public SshPublicKey sshPublicKey() {
        return this.innerModel().sshPublicKey();
    }

    @Override
    public String virtualMachineAccessId() {
        return this.innerModel().virtualMachineAccessId();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ConsoleInner innerModel() {
        return this.innerObject;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public ConsoleImpl withExistingVirtualMachine(String resourceGroupName, String virtualMachineName) {
        this.resourceGroupName = resourceGroupName;
        this.virtualMachineName = virtualMachineName;
        return this;
    }

    @Override
    public Console create() {
        this.innerObject = this.serviceManager.serviceClient().getConsoles().createOrUpdate(this.resourceGroupName, this.virtualMachineName, this.consoleName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, Context.NONE);
        return this;
    }

    @Override
    public Console create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getConsoles().createOrUpdate(this.resourceGroupName, this.virtualMachineName, this.consoleName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, context);
        return this;
    }

    ConsoleImpl(String name, NetworkCloudManager serviceManager) {
        this.innerObject = new ConsoleInner();
        this.serviceManager = serviceManager;
        this.consoleName = name;
        this.createIfMatch = null;
        this.createIfNoneMatch = null;
    }

    @Override
    public ConsoleImpl update() {
        this.updateIfMatch = null;
        this.updateIfNoneMatch = null;
        this.updateConsoleUpdateParameters = new ConsolePatchParameters();
        return this;
    }

    @Override
    public Console apply() {
        this.innerObject = this.serviceManager.serviceClient().getConsoles().update(this.resourceGroupName, this.virtualMachineName, this.consoleName, this.updateIfMatch, this.updateIfNoneMatch, this.updateConsoleUpdateParameters, Context.NONE);
        return this;
    }

    @Override
    public Console apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getConsoles().update(this.resourceGroupName, this.virtualMachineName, this.consoleName, this.updateIfMatch, this.updateIfNoneMatch, this.updateConsoleUpdateParameters, context);
        return this;
    }

    ConsoleImpl(ConsoleInner innerObject, NetworkCloudManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.virtualMachineName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "virtualMachines");
        this.consoleName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "consoles");
    }

    @Override
    public Console refresh() {
        this.innerObject = (ConsoleInner)((Object)this.serviceManager.serviceClient().getConsoles().getWithResponse(this.resourceGroupName, this.virtualMachineName, this.consoleName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Console refresh(Context context) {
        this.innerObject = (ConsoleInner)((Object)this.serviceManager.serviceClient().getConsoles().getWithResponse(this.resourceGroupName, this.virtualMachineName, this.consoleName, context).getValue());
        return this;
    }

    @Override
    public ConsoleImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ConsoleImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ConsoleImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }

    @Override
    public ConsoleImpl withEnabled(ConsoleEnabled enabled) {
        if (this.isInCreateMode()) {
            this.innerModel().withEnabled(enabled);
            return this;
        }
        this.updateConsoleUpdateParameters.withEnabled(enabled);
        return this;
    }

    @Override
    public ConsoleImpl withSshPublicKey(SshPublicKey sshPublicKey) {
        if (this.isInCreateMode()) {
            this.innerModel().withSshPublicKey(sshPublicKey);
            return this;
        }
        this.updateConsoleUpdateParameters.withSshPublicKey(sshPublicKey);
        return this;
    }

    @Override
    public ConsoleImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateConsoleUpdateParameters.withTags(tags);
        return this;
    }

    @Override
    public ConsoleImpl withExpiration(OffsetDateTime expiration) {
        if (this.isInCreateMode()) {
            this.innerModel().withExpiration(expiration);
            return this;
        }
        this.updateConsoleUpdateParameters.withExpiration(expiration);
        return this;
    }

    @Override
    public ConsoleImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    @Override
    public ConsoleImpl withIfNoneMatch(String ifNoneMatch) {
        if (this.isInCreateMode()) {
            this.createIfNoneMatch = ifNoneMatch;
            return this;
        }
        this.updateIfNoneMatch = ifNoneMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

