/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.models.ClusterInner;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.models.AnalyticsOutputSettings;
import com.azure.resourcemanager.networkcloud.models.Cluster;
import com.azure.resourcemanager.networkcloud.models.ClusterAvailableUpgradeVersion;
import com.azure.resourcemanager.networkcloud.models.ClusterCapacity;
import com.azure.resourcemanager.networkcloud.models.ClusterConnectionStatus;
import com.azure.resourcemanager.networkcloud.models.ClusterContinueUpdateVersionParameters;
import com.azure.resourcemanager.networkcloud.models.ClusterDeployParameters;
import com.azure.resourcemanager.networkcloud.models.ClusterDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.ClusterManagerConnectionStatus;
import com.azure.resourcemanager.networkcloud.models.ClusterPatchParameters;
import com.azure.resourcemanager.networkcloud.models.ClusterProvisioningState;
import com.azure.resourcemanager.networkcloud.models.ClusterScanRuntimeParameters;
import com.azure.resourcemanager.networkcloud.models.ClusterSecretArchive;
import com.azure.resourcemanager.networkcloud.models.ClusterType;
import com.azure.resourcemanager.networkcloud.models.ClusterUpdateStrategy;
import com.azure.resourcemanager.networkcloud.models.ClusterUpdateVersionParameters;
import com.azure.resourcemanager.networkcloud.models.CommandOutputSettings;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.ManagedResourceGroupConfiguration;
import com.azure.resourcemanager.networkcloud.models.ManagedServiceIdentity;
import com.azure.resourcemanager.networkcloud.models.OperationStatusResult;
import com.azure.resourcemanager.networkcloud.models.RackDefinition;
import com.azure.resourcemanager.networkcloud.models.RuntimeProtectionConfiguration;
import com.azure.resourcemanager.networkcloud.models.SecretArchiveSettings;
import com.azure.resourcemanager.networkcloud.models.ServicePrincipalInformation;
import com.azure.resourcemanager.networkcloud.models.ValidationThreshold;
import com.azure.resourcemanager.networkcloud.models.VulnerabilityScanningSettings;
import com.azure.resourcemanager.networkcloud.models.VulnerabilityScanningSettingsPatch;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ClusterImpl
implements Cluster,
Cluster.Definition,
Cluster.Update {
    private ClusterInner innerObject;
    private final NetworkCloudManager serviceManager;
    private String resourceGroupName;
    private String clusterName;
    private String createIfMatch;
    private String createIfNoneMatch;
    private String updateIfMatch;
    private String updateIfNoneMatch;
    private ClusterPatchParameters updateClusterUpdateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public ManagedServiceIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public RackDefinition aggregatorOrSingleRackDefinition() {
        return this.innerModel().aggregatorOrSingleRackDefinition();
    }

    @Override
    public AnalyticsOutputSettings analyticsOutputSettings() {
        return this.innerModel().analyticsOutputSettings();
    }

    @Override
    public String analyticsWorkspaceId() {
        return this.innerModel().analyticsWorkspaceId();
    }

    @Override
    public List<ClusterAvailableUpgradeVersion> availableUpgradeVersions() {
        List<ClusterAvailableUpgradeVersion> inner = this.innerModel().availableUpgradeVersions();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public ClusterCapacity clusterCapacity() {
        return this.innerModel().clusterCapacity();
    }

    @Override
    public ClusterConnectionStatus clusterConnectionStatus() {
        return this.innerModel().clusterConnectionStatus();
    }

    @Override
    public ExtendedLocation clusterExtendedLocation() {
        return this.innerModel().clusterExtendedLocation();
    }

    @Override
    public String clusterLocation() {
        return this.innerModel().clusterLocation();
    }

    @Override
    public ClusterManagerConnectionStatus clusterManagerConnectionStatus() {
        return this.innerModel().clusterManagerConnectionStatus();
    }

    @Override
    public String clusterManagerId() {
        return this.innerModel().clusterManagerId();
    }

    @Override
    public ServicePrincipalInformation clusterServicePrincipal() {
        return this.innerModel().clusterServicePrincipal();
    }

    @Override
    public ClusterType clusterType() {
        return this.innerModel().clusterType();
    }

    @Override
    public String clusterVersion() {
        return this.innerModel().clusterVersion();
    }

    @Override
    public CommandOutputSettings commandOutputSettings() {
        return this.innerModel().commandOutputSettings();
    }

    @Override
    public ValidationThreshold computeDeploymentThreshold() {
        return this.innerModel().computeDeploymentThreshold();
    }

    @Override
    public List<RackDefinition> computeRackDefinitions() {
        List<RackDefinition> inner = this.innerModel().computeRackDefinitions();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public ClusterDetailedStatus detailedStatus() {
        return this.innerModel().detailedStatus();
    }

    @Override
    public String detailedStatusMessage() {
        return this.innerModel().detailedStatusMessage();
    }

    @Override
    public ExtendedLocation hybridAksExtendedLocation() {
        return this.innerModel().hybridAksExtendedLocation();
    }

    @Override
    public ManagedResourceGroupConfiguration managedResourceGroupConfiguration() {
        return this.innerModel().managedResourceGroupConfiguration();
    }

    @Override
    public Long manualActionCount() {
        return this.innerModel().manualActionCount();
    }

    @Override
    public String networkFabricId() {
        return this.innerModel().networkFabricId();
    }

    @Override
    public ClusterProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public RuntimeProtectionConfiguration runtimeProtectionConfiguration() {
        return this.innerModel().runtimeProtectionConfiguration();
    }

    @Override
    public ClusterSecretArchive secretArchive() {
        return this.innerModel().secretArchive();
    }

    @Override
    public SecretArchiveSettings secretArchiveSettings() {
        return this.innerModel().secretArchiveSettings();
    }

    @Override
    public String supportExpiryDate() {
        return this.innerModel().supportExpiryDate();
    }

    @Override
    public ClusterUpdateStrategy updateStrategy() {
        return this.innerModel().updateStrategy();
    }

    @Override
    public VulnerabilityScanningSettings vulnerabilityScanningSettings() {
        return this.innerModel().vulnerabilityScanningSettings();
    }

    @Override
    public List<String> workloadResourceIds() {
        List<String> inner = this.innerModel().workloadResourceIds();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ClusterInner innerModel() {
        return this.innerObject;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public ClusterImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Cluster create() {
        this.innerObject = this.serviceManager.serviceClient().getClusters().createOrUpdate(this.resourceGroupName, this.clusterName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, Context.NONE);
        return this;
    }

    @Override
    public Cluster create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getClusters().createOrUpdate(this.resourceGroupName, this.clusterName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, context);
        return this;
    }

    ClusterImpl(String name, NetworkCloudManager serviceManager) {
        this.innerObject = new ClusterInner();
        this.serviceManager = serviceManager;
        this.clusterName = name;
        this.createIfMatch = null;
        this.createIfNoneMatch = null;
    }

    @Override
    public ClusterImpl update() {
        this.updateIfMatch = null;
        this.updateIfNoneMatch = null;
        this.updateClusterUpdateParameters = new ClusterPatchParameters();
        return this;
    }

    @Override
    public Cluster apply() {
        this.innerObject = this.serviceManager.serviceClient().getClusters().update(this.resourceGroupName, this.clusterName, this.updateIfMatch, this.updateIfNoneMatch, this.updateClusterUpdateParameters, Context.NONE);
        return this;
    }

    @Override
    public Cluster apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getClusters().update(this.resourceGroupName, this.clusterName, this.updateIfMatch, this.updateIfNoneMatch, this.updateClusterUpdateParameters, context);
        return this;
    }

    ClusterImpl(ClusterInner innerObject, NetworkCloudManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.clusterName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "clusters");
    }

    @Override
    public Cluster refresh() {
        this.innerObject = (ClusterInner)((Object)this.serviceManager.serviceClient().getClusters().getByResourceGroupWithResponse(this.resourceGroupName, this.clusterName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Cluster refresh(Context context) {
        this.innerObject = (ClusterInner)((Object)this.serviceManager.serviceClient().getClusters().getByResourceGroupWithResponse(this.resourceGroupName, this.clusterName, context).getValue());
        return this;
    }

    @Override
    public OperationStatusResult continueUpdateVersion(ClusterContinueUpdateVersionParameters clusterContinueUpdateVersionParameters) {
        return this.serviceManager.clusters().continueUpdateVersion(this.resourceGroupName, this.clusterName, clusterContinueUpdateVersionParameters);
    }

    @Override
    public OperationStatusResult continueUpdateVersion(ClusterContinueUpdateVersionParameters clusterContinueUpdateVersionParameters, Context context) {
        return this.serviceManager.clusters().continueUpdateVersion(this.resourceGroupName, this.clusterName, clusterContinueUpdateVersionParameters, context);
    }

    @Override
    public OperationStatusResult deploy() {
        return this.serviceManager.clusters().deploy(this.resourceGroupName, this.clusterName);
    }

    @Override
    public OperationStatusResult deploy(ClusterDeployParameters clusterDeployParameters, Context context) {
        return this.serviceManager.clusters().deploy(this.resourceGroupName, this.clusterName, clusterDeployParameters, context);
    }

    @Override
    public OperationStatusResult scanRuntime() {
        return this.serviceManager.clusters().scanRuntime(this.resourceGroupName, this.clusterName);
    }

    @Override
    public OperationStatusResult scanRuntime(ClusterScanRuntimeParameters clusterScanRuntimeParameters, Context context) {
        return this.serviceManager.clusters().scanRuntime(this.resourceGroupName, this.clusterName, clusterScanRuntimeParameters, context);
    }

    @Override
    public OperationStatusResult updateVersion(ClusterUpdateVersionParameters clusterUpdateVersionParameters) {
        return this.serviceManager.clusters().updateVersion(this.resourceGroupName, this.clusterName, clusterUpdateVersionParameters);
    }

    @Override
    public OperationStatusResult updateVersion(ClusterUpdateVersionParameters clusterUpdateVersionParameters, Context context) {
        return this.serviceManager.clusters().updateVersion(this.resourceGroupName, this.clusterName, clusterUpdateVersionParameters, context);
    }

    @Override
    public ClusterImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ClusterImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ClusterImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }

    @Override
    public ClusterImpl withAggregatorOrSingleRackDefinition(RackDefinition aggregatorOrSingleRackDefinition) {
        if (this.isInCreateMode()) {
            this.innerModel().withAggregatorOrSingleRackDefinition(aggregatorOrSingleRackDefinition);
            return this;
        }
        this.updateClusterUpdateParameters.withAggregatorOrSingleRackDefinition(aggregatorOrSingleRackDefinition);
        return this;
    }

    @Override
    public ClusterImpl withClusterType(ClusterType clusterType) {
        this.innerModel().withClusterType(clusterType);
        return this;
    }

    @Override
    public ClusterImpl withClusterVersion(String clusterVersion) {
        this.innerModel().withClusterVersion(clusterVersion);
        return this;
    }

    @Override
    public ClusterImpl withNetworkFabricId(String networkFabricId) {
        this.innerModel().withNetworkFabricId(networkFabricId);
        return this;
    }

    @Override
    public ClusterImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateClusterUpdateParameters.withTags(tags);
        return this;
    }

    @Override
    public ClusterImpl withIdentity(ManagedServiceIdentity identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updateClusterUpdateParameters.withIdentity(identity);
        return this;
    }

    @Override
    public ClusterImpl withAnalyticsOutputSettings(AnalyticsOutputSettings analyticsOutputSettings) {
        if (this.isInCreateMode()) {
            this.innerModel().withAnalyticsOutputSettings(analyticsOutputSettings);
            return this;
        }
        this.updateClusterUpdateParameters.withAnalyticsOutputSettings(analyticsOutputSettings);
        return this;
    }

    @Override
    public ClusterImpl withAnalyticsWorkspaceId(String analyticsWorkspaceId) {
        this.innerModel().withAnalyticsWorkspaceId(analyticsWorkspaceId);
        return this;
    }

    @Override
    public ClusterImpl withClusterLocation(String clusterLocation) {
        if (this.isInCreateMode()) {
            this.innerModel().withClusterLocation(clusterLocation);
            return this;
        }
        this.updateClusterUpdateParameters.withClusterLocation(clusterLocation);
        return this;
    }

    @Override
    public ClusterImpl withClusterServicePrincipal(ServicePrincipalInformation clusterServicePrincipal) {
        if (this.isInCreateMode()) {
            this.innerModel().withClusterServicePrincipal(clusterServicePrincipal);
            return this;
        }
        this.updateClusterUpdateParameters.withClusterServicePrincipal(clusterServicePrincipal);
        return this;
    }

    @Override
    public ClusterImpl withCommandOutputSettings(CommandOutputSettings commandOutputSettings) {
        if (this.isInCreateMode()) {
            this.innerModel().withCommandOutputSettings(commandOutputSettings);
            return this;
        }
        this.updateClusterUpdateParameters.withCommandOutputSettings(commandOutputSettings);
        return this;
    }

    @Override
    public ClusterImpl withComputeDeploymentThreshold(ValidationThreshold computeDeploymentThreshold) {
        if (this.isInCreateMode()) {
            this.innerModel().withComputeDeploymentThreshold(computeDeploymentThreshold);
            return this;
        }
        this.updateClusterUpdateParameters.withComputeDeploymentThreshold(computeDeploymentThreshold);
        return this;
    }

    @Override
    public ClusterImpl withComputeRackDefinitions(List<RackDefinition> computeRackDefinitions) {
        if (this.isInCreateMode()) {
            this.innerModel().withComputeRackDefinitions(computeRackDefinitions);
            return this;
        }
        this.updateClusterUpdateParameters.withComputeRackDefinitions(computeRackDefinitions);
        return this;
    }

    @Override
    public ClusterImpl withManagedResourceGroupConfiguration(ManagedResourceGroupConfiguration managedResourceGroupConfiguration) {
        this.innerModel().withManagedResourceGroupConfiguration(managedResourceGroupConfiguration);
        return this;
    }

    @Override
    public ClusterImpl withRuntimeProtectionConfiguration(RuntimeProtectionConfiguration runtimeProtectionConfiguration) {
        if (this.isInCreateMode()) {
            this.innerModel().withRuntimeProtectionConfiguration(runtimeProtectionConfiguration);
            return this;
        }
        this.updateClusterUpdateParameters.withRuntimeProtectionConfiguration(runtimeProtectionConfiguration);
        return this;
    }

    @Override
    public ClusterImpl withSecretArchive(ClusterSecretArchive secretArchive) {
        if (this.isInCreateMode()) {
            this.innerModel().withSecretArchive(secretArchive);
            return this;
        }
        this.updateClusterUpdateParameters.withSecretArchive(secretArchive);
        return this;
    }

    @Override
    public ClusterImpl withSecretArchiveSettings(SecretArchiveSettings secretArchiveSettings) {
        if (this.isInCreateMode()) {
            this.innerModel().withSecretArchiveSettings(secretArchiveSettings);
            return this;
        }
        this.updateClusterUpdateParameters.withSecretArchiveSettings(secretArchiveSettings);
        return this;
    }

    @Override
    public ClusterImpl withUpdateStrategy(ClusterUpdateStrategy updateStrategy) {
        if (this.isInCreateMode()) {
            this.innerModel().withUpdateStrategy(updateStrategy);
            return this;
        }
        this.updateClusterUpdateParameters.withUpdateStrategy(updateStrategy);
        return this;
    }

    @Override
    public ClusterImpl withVulnerabilityScanningSettings(VulnerabilityScanningSettings vulnerabilityScanningSettings) {
        this.innerModel().withVulnerabilityScanningSettings(vulnerabilityScanningSettings);
        return this;
    }

    @Override
    public ClusterImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    @Override
    public ClusterImpl withIfNoneMatch(String ifNoneMatch) {
        if (this.isInCreateMode()) {
            this.createIfNoneMatch = ifNoneMatch;
            return this;
        }
        this.updateIfNoneMatch = ifNoneMatch;
        return this;
    }

    @Override
    public ClusterImpl withVulnerabilityScanningSettings(VulnerabilityScanningSettingsPatch vulnerabilityScanningSettings) {
        this.updateClusterUpdateParameters.withVulnerabilityScanningSettings(vulnerabilityScanningSettings);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

