/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.AgentPoolsClient;
import com.azure.resourcemanager.networkcloud.fluent.models.AgentPoolInner;
import com.azure.resourcemanager.networkcloud.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.networkcloud.implementation.AgentPoolImpl;
import com.azure.resourcemanager.networkcloud.implementation.OperationStatusResultImpl;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.models.AgentPool;
import com.azure.resourcemanager.networkcloud.models.AgentPools;
import com.azure.resourcemanager.networkcloud.models.OperationStatusResult;

public final class AgentPoolsImpl
implements AgentPools {
    private static final ClientLogger LOGGER = new ClientLogger(AgentPoolsImpl.class);
    private final AgentPoolsClient innerClient;
    private final NetworkCloudManager serviceManager;

    public AgentPoolsImpl(AgentPoolsClient innerClient, NetworkCloudManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<AgentPool> listByKubernetesCluster(String resourceGroupName, String kubernetesClusterName) {
        PagedIterable<AgentPoolInner> inner = this.serviceClient().listByKubernetesCluster(resourceGroupName, kubernetesClusterName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AgentPoolImpl((AgentPoolInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AgentPool> listByKubernetesCluster(String resourceGroupName, String kubernetesClusterName, Context context) {
        PagedIterable<AgentPoolInner> inner = this.serviceClient().listByKubernetesCluster(resourceGroupName, kubernetesClusterName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AgentPoolImpl((AgentPoolInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<AgentPool> getWithResponse(String resourceGroupName, String kubernetesClusterName, String agentPoolName, Context context) {
        Response<AgentPoolInner> inner = this.serviceClient().getWithResponse(resourceGroupName, kubernetesClusterName, agentPoolName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AgentPoolImpl((AgentPoolInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public AgentPool get(String resourceGroupName, String kubernetesClusterName, String agentPoolName) {
        AgentPoolInner inner = this.serviceClient().get(resourceGroupName, kubernetesClusterName, agentPoolName);
        if (inner != null) {
            return new AgentPoolImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult delete(String resourceGroupName, String kubernetesClusterName, String agentPoolName) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, kubernetesClusterName, agentPoolName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult delete(String resourceGroupName, String kubernetesClusterName, String agentPoolName, String ifMatch, String ifNoneMatch, Context context) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, kubernetesClusterName, agentPoolName, ifMatch, ifNoneMatch, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public AgentPool getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String kubernetesClusterName = ResourceManagerUtils.getValueFromIdByName(id, "kubernetesClusters");
        if (kubernetesClusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'kubernetesClusters'.", id)));
        }
        String agentPoolName = ResourceManagerUtils.getValueFromIdByName(id, "agentPools");
        if (agentPoolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'agentPools'.", id)));
        }
        return (AgentPool)this.getWithResponse(resourceGroupName, kubernetesClusterName, agentPoolName, Context.NONE).getValue();
    }

    @Override
    public Response<AgentPool> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String kubernetesClusterName = ResourceManagerUtils.getValueFromIdByName(id, "kubernetesClusters");
        if (kubernetesClusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'kubernetesClusters'.", id)));
        }
        String agentPoolName = ResourceManagerUtils.getValueFromIdByName(id, "agentPools");
        if (agentPoolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'agentPools'.", id)));
        }
        return this.getWithResponse(resourceGroupName, kubernetesClusterName, agentPoolName, context);
    }

    @Override
    public OperationStatusResult deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String kubernetesClusterName = ResourceManagerUtils.getValueFromIdByName(id, "kubernetesClusters");
        if (kubernetesClusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'kubernetesClusters'.", id)));
        }
        String agentPoolName = ResourceManagerUtils.getValueFromIdByName(id, "agentPools");
        if (agentPoolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'agentPools'.", id)));
        }
        String localIfMatch = null;
        String localIfNoneMatch = null;
        return this.delete(resourceGroupName, kubernetesClusterName, agentPoolName, localIfMatch, localIfNoneMatch, Context.NONE);
    }

    @Override
    public OperationStatusResult deleteByIdWithResponse(String id, String ifMatch, String ifNoneMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String kubernetesClusterName = ResourceManagerUtils.getValueFromIdByName(id, "kubernetesClusters");
        if (kubernetesClusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'kubernetesClusters'.", id)));
        }
        String agentPoolName = ResourceManagerUtils.getValueFromIdByName(id, "agentPools");
        if (agentPoolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'agentPools'.", id)));
        }
        return this.delete(resourceGroupName, kubernetesClusterName, agentPoolName, ifMatch, ifNoneMatch, context);
    }

    private AgentPoolsClient serviceClient() {
        return this.innerClient;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public AgentPoolImpl define(String name) {
        return new AgentPoolImpl(name, this.manager());
    }
}

