/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.networkcloud.fluent.AgentPoolsClient;
import com.azure.resourcemanager.networkcloud.fluent.models.AgentPoolInner;
import com.azure.resourcemanager.networkcloud.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.networkcloud.implementation.NetworkCloudImpl;
import com.azure.resourcemanager.networkcloud.models.AgentPoolList;
import com.azure.resourcemanager.networkcloud.models.AgentPoolPatchParameters;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class AgentPoolsClientImpl
implements AgentPoolsClient {
    private final AgentPoolsService service;
    private final NetworkCloudImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(AgentPoolsClientImpl.class);

    AgentPoolsClientImpl(NetworkCloudImpl client) {
        this.service = (AgentPoolsService)RestProxy.create(AgentPoolsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AgentPoolInner>> listByKubernetesClusterSinglePageAsync(String resourceGroupName, String kubernetesClusterName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByKubernetesCluster(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AgentPoolList)res.getValue()).value(), ((AgentPoolList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AgentPoolInner> listByKubernetesClusterAsync(String resourceGroupName, String kubernetesClusterName) {
        return new PagedFlux(() -> this.listByKubernetesClusterSinglePageAsync(resourceGroupName, kubernetesClusterName), nextLink -> this.listByKubernetesClusterNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<AgentPoolInner> listByKubernetesClusterSinglePage(String resourceGroupName, String kubernetesClusterName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<AgentPoolList> res = this.service.listByKubernetesClusterSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AgentPoolList)res.getValue()).value(), ((AgentPoolList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<AgentPoolInner> listByKubernetesClusterSinglePage(String resourceGroupName, String kubernetesClusterName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<AgentPoolList> res = this.service.listByKubernetesClusterSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AgentPoolList)res.getValue()).value(), ((AgentPoolList)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AgentPoolInner> listByKubernetesCluster(String resourceGroupName, String kubernetesClusterName) {
        return new PagedIterable(() -> this.listByKubernetesClusterSinglePage(resourceGroupName, kubernetesClusterName), nextLink -> this.listByKubernetesClusterNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AgentPoolInner> listByKubernetesCluster(String resourceGroupName, String kubernetesClusterName, Context context) {
        return new PagedIterable(() -> this.listByKubernetesClusterSinglePage(resourceGroupName, kubernetesClusterName, context), nextLink -> this.listByKubernetesClusterNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AgentPoolInner>> getWithResponseAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, agentPoolName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AgentPoolInner> getAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName) {
        return this.getWithResponseAsync(resourceGroupName, kubernetesClusterName, agentPoolName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((AgentPoolInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AgentPoolInner> getWithResponse(String resourceGroupName, String kubernetesClusterName, String agentPoolName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, agentPoolName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AgentPoolInner get(String resourceGroupName, String kubernetesClusterName, String agentPoolName) {
        return (AgentPoolInner)((Object)this.getWithResponse(resourceGroupName, kubernetesClusterName, agentPoolName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName, AgentPoolInner agentPoolParameters, String ifMatch, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        if (agentPoolParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter agentPoolParameters is required and cannot be null."));
        }
        agentPoolParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, agentPoolName, ifMatch, ifNoneMatch, agentPoolParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String kubernetesClusterName, String agentPoolName, AgentPoolInner agentPoolParameters, String ifMatch, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        if (agentPoolParameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter agentPoolParameters is required and cannot be null."));
        }
        agentPoolParameters.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, agentPoolName, ifMatch, ifNoneMatch, agentPoolParameters, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String kubernetesClusterName, String agentPoolName, AgentPoolInner agentPoolParameters, String ifMatch, String ifNoneMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        if (agentPoolParameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter agentPoolParameters is required and cannot be null."));
        }
        agentPoolParameters.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, agentPoolName, ifMatch, ifNoneMatch, agentPoolParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AgentPoolInner>, AgentPoolInner> beginCreateOrUpdateAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName, AgentPoolInner agentPoolParameters, String ifMatch, String ifNoneMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, kubernetesClusterName, agentPoolName, agentPoolParameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AgentPoolInner.class), (Type)((Object)AgentPoolInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AgentPoolInner>, AgentPoolInner> beginCreateOrUpdateAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName, AgentPoolInner agentPoolParameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, kubernetesClusterName, agentPoolName, agentPoolParameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AgentPoolInner.class), (Type)((Object)AgentPoolInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AgentPoolInner>, AgentPoolInner> beginCreateOrUpdate(String resourceGroupName, String kubernetesClusterName, String agentPoolName, AgentPoolInner agentPoolParameters, String ifMatch, String ifNoneMatch) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, kubernetesClusterName, agentPoolName, agentPoolParameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(response, (Type)((Object)AgentPoolInner.class), (Type)((Object)AgentPoolInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AgentPoolInner>, AgentPoolInner> beginCreateOrUpdate(String resourceGroupName, String kubernetesClusterName, String agentPoolName, AgentPoolInner agentPoolParameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, kubernetesClusterName, agentPoolName, agentPoolParameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(response, (Type)((Object)AgentPoolInner.class), (Type)((Object)AgentPoolInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AgentPoolInner>, AgentPoolInner> beginCreateOrUpdate(String resourceGroupName, String kubernetesClusterName, String agentPoolName, AgentPoolInner agentPoolParameters, String ifMatch, String ifNoneMatch, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, kubernetesClusterName, agentPoolName, agentPoolParameters, ifMatch, ifNoneMatch, context);
        return this.client.getLroResult(response, (Type)((Object)AgentPoolInner.class), (Type)((Object)AgentPoolInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AgentPoolInner> createOrUpdateAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName, AgentPoolInner agentPoolParameters, String ifMatch, String ifNoneMatch) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, kubernetesClusterName, agentPoolName, agentPoolParameters, ifMatch, ifNoneMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AgentPoolInner> createOrUpdateAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName, AgentPoolInner agentPoolParameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return this.beginCreateOrUpdateAsync(resourceGroupName, kubernetesClusterName, agentPoolName, agentPoolParameters, ifMatch, ifNoneMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AgentPoolInner createOrUpdate(String resourceGroupName, String kubernetesClusterName, String agentPoolName, AgentPoolInner agentPoolParameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return (AgentPoolInner)((Object)this.beginCreateOrUpdate(resourceGroupName, kubernetesClusterName, agentPoolName, agentPoolParameters, ifMatch, ifNoneMatch).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AgentPoolInner createOrUpdate(String resourceGroupName, String kubernetesClusterName, String agentPoolName, AgentPoolInner agentPoolParameters, String ifMatch, String ifNoneMatch, Context context) {
        return (AgentPoolInner)((Object)this.beginCreateOrUpdate(resourceGroupName, kubernetesClusterName, agentPoolName, agentPoolParameters, ifMatch, ifNoneMatch, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName, String ifMatch, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, agentPoolName, ifMatch, ifNoneMatch, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String kubernetesClusterName, String agentPoolName, String ifMatch, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, agentPoolName, ifMatch, ifNoneMatch, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String kubernetesClusterName, String agentPoolName, String ifMatch, String ifNoneMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, agentPoolName, ifMatch, ifNoneMatch, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDeleteAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName, String ifMatch, String ifNoneMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, kubernetesClusterName, agentPoolName, ifMatch, ifNoneMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDeleteAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, kubernetesClusterName, agentPoolName, ifMatch, ifNoneMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDelete(String resourceGroupName, String kubernetesClusterName, String agentPoolName, String ifMatch, String ifNoneMatch) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, kubernetesClusterName, agentPoolName, ifMatch, ifNoneMatch);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDelete(String resourceGroupName, String kubernetesClusterName, String agentPoolName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, kubernetesClusterName, agentPoolName, ifMatch, ifNoneMatch);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDelete(String resourceGroupName, String kubernetesClusterName, String agentPoolName, String ifMatch, String ifNoneMatch, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, kubernetesClusterName, agentPoolName, ifMatch, ifNoneMatch, context);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> deleteAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName, String ifMatch, String ifNoneMatch) {
        return this.beginDeleteAsync(resourceGroupName, kubernetesClusterName, agentPoolName, ifMatch, ifNoneMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> deleteAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return this.beginDeleteAsync(resourceGroupName, kubernetesClusterName, agentPoolName, ifMatch, ifNoneMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner delete(String resourceGroupName, String kubernetesClusterName, String agentPoolName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return (OperationStatusResultInner)this.beginDelete(resourceGroupName, kubernetesClusterName, agentPoolName, ifMatch, ifNoneMatch).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner delete(String resourceGroupName, String kubernetesClusterName, String agentPoolName, String ifMatch, String ifNoneMatch, Context context) {
        return (OperationStatusResultInner)this.beginDelete(resourceGroupName, kubernetesClusterName, agentPoolName, ifMatch, ifNoneMatch, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName, String ifMatch, String ifNoneMatch, AgentPoolPatchParameters agentPoolUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        if (agentPoolUpdateParameters != null) {
            agentPoolUpdateParameters.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, agentPoolName, ifMatch, ifNoneMatch, agentPoolUpdateParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String kubernetesClusterName, String agentPoolName, String ifMatch, String ifNoneMatch, AgentPoolPatchParameters agentPoolUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        if (agentPoolUpdateParameters != null) {
            agentPoolUpdateParameters.validate();
        }
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, agentPoolName, ifMatch, ifNoneMatch, agentPoolUpdateParameters, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String kubernetesClusterName, String agentPoolName, String ifMatch, String ifNoneMatch, AgentPoolPatchParameters agentPoolUpdateParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (kubernetesClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter kubernetesClusterName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        if (agentPoolUpdateParameters != null) {
            agentPoolUpdateParameters.validate();
        }
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, kubernetesClusterName, agentPoolName, ifMatch, ifNoneMatch, agentPoolUpdateParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AgentPoolInner>, AgentPoolInner> beginUpdateAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName, String ifMatch, String ifNoneMatch, AgentPoolPatchParameters agentPoolUpdateParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, kubernetesClusterName, agentPoolName, ifMatch, ifNoneMatch, agentPoolUpdateParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AgentPoolInner.class), (Type)((Object)AgentPoolInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AgentPoolInner>, AgentPoolInner> beginUpdateAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        AgentPoolPatchParameters agentPoolUpdateParameters = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, kubernetesClusterName, agentPoolName, ifMatch, ifNoneMatch, agentPoolUpdateParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AgentPoolInner.class), (Type)((Object)AgentPoolInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AgentPoolInner>, AgentPoolInner> beginUpdate(String resourceGroupName, String kubernetesClusterName, String agentPoolName, String ifMatch, String ifNoneMatch, AgentPoolPatchParameters agentPoolUpdateParameters) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, kubernetesClusterName, agentPoolName, ifMatch, ifNoneMatch, agentPoolUpdateParameters);
        return this.client.getLroResult(response, (Type)((Object)AgentPoolInner.class), (Type)((Object)AgentPoolInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AgentPoolInner>, AgentPoolInner> beginUpdate(String resourceGroupName, String kubernetesClusterName, String agentPoolName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        AgentPoolPatchParameters agentPoolUpdateParameters = null;
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, kubernetesClusterName, agentPoolName, ifMatch, ifNoneMatch, agentPoolUpdateParameters);
        return this.client.getLroResult(response, (Type)((Object)AgentPoolInner.class), (Type)((Object)AgentPoolInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AgentPoolInner>, AgentPoolInner> beginUpdate(String resourceGroupName, String kubernetesClusterName, String agentPoolName, String ifMatch, String ifNoneMatch, AgentPoolPatchParameters agentPoolUpdateParameters, Context context) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, kubernetesClusterName, agentPoolName, ifMatch, ifNoneMatch, agentPoolUpdateParameters, context);
        return this.client.getLroResult(response, (Type)((Object)AgentPoolInner.class), (Type)((Object)AgentPoolInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AgentPoolInner> updateAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName, String ifMatch, String ifNoneMatch, AgentPoolPatchParameters agentPoolUpdateParameters) {
        return this.beginUpdateAsync(resourceGroupName, kubernetesClusterName, agentPoolName, ifMatch, ifNoneMatch, agentPoolUpdateParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AgentPoolInner> updateAsync(String resourceGroupName, String kubernetesClusterName, String agentPoolName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        AgentPoolPatchParameters agentPoolUpdateParameters = null;
        return this.beginUpdateAsync(resourceGroupName, kubernetesClusterName, agentPoolName, ifMatch, ifNoneMatch, agentPoolUpdateParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AgentPoolInner update(String resourceGroupName, String kubernetesClusterName, String agentPoolName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        AgentPoolPatchParameters agentPoolUpdateParameters = null;
        return (AgentPoolInner)((Object)this.beginUpdate(resourceGroupName, kubernetesClusterName, agentPoolName, ifMatch, ifNoneMatch, agentPoolUpdateParameters).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AgentPoolInner update(String resourceGroupName, String kubernetesClusterName, String agentPoolName, String ifMatch, String ifNoneMatch, AgentPoolPatchParameters agentPoolUpdateParameters, Context context) {
        return (AgentPoolInner)((Object)this.beginUpdate(resourceGroupName, kubernetesClusterName, agentPoolName, ifMatch, ifNoneMatch, agentPoolUpdateParameters, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AgentPoolInner>> listByKubernetesClusterNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByKubernetesClusterNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AgentPoolList)res.getValue()).value(), ((AgentPoolList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<AgentPoolInner> listByKubernetesClusterNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<AgentPoolList> res = this.service.listByKubernetesClusterNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AgentPoolList)res.getValue()).value(), ((AgentPoolList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<AgentPoolInner> listByKubernetesClusterNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<AgentPoolList> res = this.service.listByKubernetesClusterNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AgentPoolList)res.getValue()).value(), ((AgentPoolList)res.getValue()).nextLink(), null);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkCloudAgentPools")
    public static interface AgentPoolsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}/agentPools")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AgentPoolList>> listByKubernetesCluster(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="kubernetesClusterName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}/agentPools")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<AgentPoolList> listByKubernetesClusterSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="kubernetesClusterName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}/agentPools/{agentPoolName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AgentPoolInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="kubernetesClusterName") String var5, @PathParam(value="agentPoolName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}/agentPools/{agentPoolName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<AgentPoolInner> getSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="kubernetesClusterName") String var5, @PathParam(value="agentPoolName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}/agentPools/{agentPoolName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="kubernetesClusterName") String var5, @PathParam(value="agentPoolName") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, @BodyParam(value="application/json") AgentPoolInner var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}/agentPools/{agentPoolName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="kubernetesClusterName") String var5, @PathParam(value="agentPoolName") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, @BodyParam(value="application/json") AgentPoolInner var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}/agentPools/{agentPoolName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="kubernetesClusterName") String var5, @PathParam(value="agentPoolName") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}/agentPools/{agentPoolName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="kubernetesClusterName") String var5, @PathParam(value="agentPoolName") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}/agentPools/{agentPoolName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="kubernetesClusterName") String var5, @PathParam(value="agentPoolName") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, @BodyParam(value="application/json") AgentPoolPatchParameters var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}/agentPools/{agentPoolName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> updateSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="kubernetesClusterName") String var5, @PathParam(value="agentPoolName") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, @BodyParam(value="application/json") AgentPoolPatchParameters var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AgentPoolList>> listByKubernetesClusterNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<AgentPoolList> listByKubernetesClusterNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

