/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.HybridAksPluginType;
import com.azure.resourcemanager.networkcloud.models.TrunkedNetworkDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.TrunkedNetworkProvisioningState;
import java.io.IOException;
import java.util.List;

public final class TrunkedNetworkProperties
implements JsonSerializable<TrunkedNetworkProperties> {
    private List<String> associatedResourceIds;
    private String clusterId;
    private TrunkedNetworkDetailedStatus detailedStatus;
    private String detailedStatusMessage;
    private List<String> hybridAksClustersAssociatedIds;
    private HybridAksPluginType hybridAksPluginType;
    private String interfaceName;
    private List<String> isolationDomainIds;
    private TrunkedNetworkProvisioningState provisioningState;
    private List<String> virtualMachinesAssociatedIds;
    private List<Long> vlans;
    private static final ClientLogger LOGGER = new ClientLogger(TrunkedNetworkProperties.class);

    public List<String> associatedResourceIds() {
        return this.associatedResourceIds;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public TrunkedNetworkDetailedStatus detailedStatus() {
        return this.detailedStatus;
    }

    public String detailedStatusMessage() {
        return this.detailedStatusMessage;
    }

    public List<String> hybridAksClustersAssociatedIds() {
        return this.hybridAksClustersAssociatedIds;
    }

    public HybridAksPluginType hybridAksPluginType() {
        return this.hybridAksPluginType;
    }

    public TrunkedNetworkProperties withHybridAksPluginType(HybridAksPluginType hybridAksPluginType) {
        this.hybridAksPluginType = hybridAksPluginType;
        return this;
    }

    public String interfaceName() {
        return this.interfaceName;
    }

    public TrunkedNetworkProperties withInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
        return this;
    }

    public List<String> isolationDomainIds() {
        return this.isolationDomainIds;
    }

    public TrunkedNetworkProperties withIsolationDomainIds(List<String> isolationDomainIds) {
        this.isolationDomainIds = isolationDomainIds;
        return this;
    }

    public TrunkedNetworkProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<String> virtualMachinesAssociatedIds() {
        return this.virtualMachinesAssociatedIds;
    }

    public List<Long> vlans() {
        return this.vlans;
    }

    public TrunkedNetworkProperties withVlans(List<Long> vlans) {
        this.vlans = vlans;
        return this;
    }

    public void validate() {
        if (this.isolationDomainIds() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property isolationDomainIds in model TrunkedNetworkProperties"));
        }
        if (this.vlans() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property vlans in model TrunkedNetworkProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("isolationDomainIds", this.isolationDomainIds, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("vlans", this.vlans, (writer, element) -> writer.writeLong(element.longValue()));
        jsonWriter.writeStringField("hybridAksPluginType", this.hybridAksPluginType == null ? null : this.hybridAksPluginType.toString());
        jsonWriter.writeStringField("interfaceName", this.interfaceName);
        return jsonWriter.writeEndObject();
    }

    public static TrunkedNetworkProperties fromJson(JsonReader jsonReader) throws IOException {
        return (TrunkedNetworkProperties)jsonReader.readObject(reader -> {
            TrunkedNetworkProperties deserializedTrunkedNetworkProperties = new TrunkedNetworkProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("isolationDomainIds".equals(fieldName)) {
                    List isolationDomainIds;
                    deserializedTrunkedNetworkProperties.isolationDomainIds = isolationDomainIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("vlans".equals(fieldName)) {
                    List vlans;
                    deserializedTrunkedNetworkProperties.vlans = vlans = reader.readArray(reader1 -> reader1.getLong());
                    continue;
                }
                if ("associatedResourceIds".equals(fieldName)) {
                    List associatedResourceIds;
                    deserializedTrunkedNetworkProperties.associatedResourceIds = associatedResourceIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("clusterId".equals(fieldName)) {
                    deserializedTrunkedNetworkProperties.clusterId = reader.getString();
                    continue;
                }
                if ("detailedStatus".equals(fieldName)) {
                    deserializedTrunkedNetworkProperties.detailedStatus = TrunkedNetworkDetailedStatus.fromString(reader.getString());
                    continue;
                }
                if ("detailedStatusMessage".equals(fieldName)) {
                    deserializedTrunkedNetworkProperties.detailedStatusMessage = reader.getString();
                    continue;
                }
                if ("hybridAksClustersAssociatedIds".equals(fieldName)) {
                    List hybridAksClustersAssociatedIds;
                    deserializedTrunkedNetworkProperties.hybridAksClustersAssociatedIds = hybridAksClustersAssociatedIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("hybridAksPluginType".equals(fieldName)) {
                    deserializedTrunkedNetworkProperties.hybridAksPluginType = HybridAksPluginType.fromString(reader.getString());
                    continue;
                }
                if ("interfaceName".equals(fieldName)) {
                    deserializedTrunkedNetworkProperties.interfaceName = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedTrunkedNetworkProperties.provisioningState = TrunkedNetworkProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("virtualMachinesAssociatedIds".equals(fieldName)) {
                    List virtualMachinesAssociatedIds;
                    deserializedTrunkedNetworkProperties.virtualMachinesAssociatedIds = virtualMachinesAssociatedIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTrunkedNetworkProperties;
        });
    }
}

