/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.RackDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.RackProvisioningState;
import java.io.IOException;

public final class RackProperties
implements JsonSerializable<RackProperties> {
    private String availabilityZone;
    private String clusterId;
    private RackDetailedStatus detailedStatus;
    private String detailedStatusMessage;
    private RackProvisioningState provisioningState;
    private String rackLocation;
    private String rackSerialNumber;
    private String rackSkuId;
    private static final ClientLogger LOGGER = new ClientLogger(RackProperties.class);

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public RackProperties withAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public RackDetailedStatus detailedStatus() {
        return this.detailedStatus;
    }

    public String detailedStatusMessage() {
        return this.detailedStatusMessage;
    }

    public RackProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String rackLocation() {
        return this.rackLocation;
    }

    public RackProperties withRackLocation(String rackLocation) {
        this.rackLocation = rackLocation;
        return this;
    }

    public String rackSerialNumber() {
        return this.rackSerialNumber;
    }

    public RackProperties withRackSerialNumber(String rackSerialNumber) {
        this.rackSerialNumber = rackSerialNumber;
        return this;
    }

    public String rackSkuId() {
        return this.rackSkuId;
    }

    public RackProperties withRackSkuId(String rackSkuId) {
        this.rackSkuId = rackSkuId;
        return this;
    }

    public void validate() {
        if (this.availabilityZone() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property availabilityZone in model RackProperties"));
        }
        if (this.rackLocation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property rackLocation in model RackProperties"));
        }
        if (this.rackSerialNumber() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property rackSerialNumber in model RackProperties"));
        }
        if (this.rackSkuId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property rackSkuId in model RackProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("availabilityZone", this.availabilityZone);
        jsonWriter.writeStringField("rackLocation", this.rackLocation);
        jsonWriter.writeStringField("rackSerialNumber", this.rackSerialNumber);
        jsonWriter.writeStringField("rackSkuId", this.rackSkuId);
        return jsonWriter.writeEndObject();
    }

    public static RackProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RackProperties)jsonReader.readObject(reader -> {
            RackProperties deserializedRackProperties = new RackProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("availabilityZone".equals(fieldName)) {
                    deserializedRackProperties.availabilityZone = reader.getString();
                    continue;
                }
                if ("rackLocation".equals(fieldName)) {
                    deserializedRackProperties.rackLocation = reader.getString();
                    continue;
                }
                if ("rackSerialNumber".equals(fieldName)) {
                    deserializedRackProperties.rackSerialNumber = reader.getString();
                    continue;
                }
                if ("rackSkuId".equals(fieldName)) {
                    deserializedRackProperties.rackSkuId = reader.getString();
                    continue;
                }
                if ("clusterId".equals(fieldName)) {
                    deserializedRackProperties.clusterId = reader.getString();
                    continue;
                }
                if ("detailedStatus".equals(fieldName)) {
                    deserializedRackProperties.detailedStatus = RackDetailedStatus.fromString(reader.getString());
                    continue;
                }
                if ("detailedStatusMessage".equals(fieldName)) {
                    deserializedRackProperties.detailedStatusMessage = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedRackProperties.provisioningState = RackProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRackProperties;
        });
    }
}

