/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.AdministratorConfigurationPatch;
import com.azure.resourcemanager.networkcloud.models.ControlPlaneNodePatchConfiguration;
import java.io.IOException;

public final class KubernetesClusterPatchProperties
implements JsonSerializable<KubernetesClusterPatchProperties> {
    private AdministratorConfigurationPatch administratorConfiguration;
    private ControlPlaneNodePatchConfiguration controlPlaneNodeConfiguration;
    private String kubernetesVersion;

    public AdministratorConfigurationPatch administratorConfiguration() {
        return this.administratorConfiguration;
    }

    public KubernetesClusterPatchProperties withAdministratorConfiguration(AdministratorConfigurationPatch administratorConfiguration) {
        this.administratorConfiguration = administratorConfiguration;
        return this;
    }

    public ControlPlaneNodePatchConfiguration controlPlaneNodeConfiguration() {
        return this.controlPlaneNodeConfiguration;
    }

    public KubernetesClusterPatchProperties withControlPlaneNodeConfiguration(ControlPlaneNodePatchConfiguration controlPlaneNodeConfiguration) {
        this.controlPlaneNodeConfiguration = controlPlaneNodeConfiguration;
        return this;
    }

    public String kubernetesVersion() {
        return this.kubernetesVersion;
    }

    public KubernetesClusterPatchProperties withKubernetesVersion(String kubernetesVersion) {
        this.kubernetesVersion = kubernetesVersion;
        return this;
    }

    public void validate() {
        if (this.administratorConfiguration() != null) {
            this.administratorConfiguration().validate();
        }
        if (this.controlPlaneNodeConfiguration() != null) {
            this.controlPlaneNodeConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("administratorConfiguration", (JsonSerializable)this.administratorConfiguration);
        jsonWriter.writeJsonField("controlPlaneNodeConfiguration", (JsonSerializable)this.controlPlaneNodeConfiguration);
        jsonWriter.writeStringField("kubernetesVersion", this.kubernetesVersion);
        return jsonWriter.writeEndObject();
    }

    public static KubernetesClusterPatchProperties fromJson(JsonReader jsonReader) throws IOException {
        return (KubernetesClusterPatchProperties)jsonReader.readObject(reader -> {
            KubernetesClusterPatchProperties deserializedKubernetesClusterPatchProperties = new KubernetesClusterPatchProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("administratorConfiguration".equals(fieldName)) {
                    deserializedKubernetesClusterPatchProperties.administratorConfiguration = AdministratorConfigurationPatch.fromJson(reader);
                    continue;
                }
                if ("controlPlaneNodeConfiguration".equals(fieldName)) {
                    deserializedKubernetesClusterPatchProperties.controlPlaneNodeConfiguration = ControlPlaneNodePatchConfiguration.fromJson(reader);
                    continue;
                }
                if ("kubernetesVersion".equals(fieldName)) {
                    deserializedKubernetesClusterPatchProperties.kubernetesVersion = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKubernetesClusterPatchProperties;
        });
    }
}

