/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.BmcKeySetDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.BmcKeySetPrivilegeLevel;
import com.azure.resourcemanager.networkcloud.models.BmcKeySetProvisioningState;
import com.azure.resourcemanager.networkcloud.models.KeySetUser;
import com.azure.resourcemanager.networkcloud.models.KeySetUserStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class BmcKeySetProperties
implements JsonSerializable<BmcKeySetProperties> {
    private String azureGroupId;
    private BmcKeySetDetailedStatus detailedStatus;
    private String detailedStatusMessage;
    private OffsetDateTime expiration;
    private OffsetDateTime lastValidation;
    private BmcKeySetPrivilegeLevel privilegeLevel;
    private BmcKeySetProvisioningState provisioningState;
    private List<KeySetUser> userList;
    private List<KeySetUserStatus> userListStatus;
    private static final ClientLogger LOGGER = new ClientLogger(BmcKeySetProperties.class);

    public String azureGroupId() {
        return this.azureGroupId;
    }

    public BmcKeySetProperties withAzureGroupId(String azureGroupId) {
        this.azureGroupId = azureGroupId;
        return this;
    }

    public BmcKeySetDetailedStatus detailedStatus() {
        return this.detailedStatus;
    }

    public String detailedStatusMessage() {
        return this.detailedStatusMessage;
    }

    public OffsetDateTime expiration() {
        return this.expiration;
    }

    public BmcKeySetProperties withExpiration(OffsetDateTime expiration) {
        this.expiration = expiration;
        return this;
    }

    public OffsetDateTime lastValidation() {
        return this.lastValidation;
    }

    public BmcKeySetPrivilegeLevel privilegeLevel() {
        return this.privilegeLevel;
    }

    public BmcKeySetProperties withPrivilegeLevel(BmcKeySetPrivilegeLevel privilegeLevel) {
        this.privilegeLevel = privilegeLevel;
        return this;
    }

    public BmcKeySetProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<KeySetUser> userList() {
        return this.userList;
    }

    public BmcKeySetProperties withUserList(List<KeySetUser> userList) {
        this.userList = userList;
        return this;
    }

    public List<KeySetUserStatus> userListStatus() {
        return this.userListStatus;
    }

    public void validate() {
        if (this.azureGroupId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property azureGroupId in model BmcKeySetProperties"));
        }
        if (this.expiration() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property expiration in model BmcKeySetProperties"));
        }
        if (this.privilegeLevel() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property privilegeLevel in model BmcKeySetProperties"));
        }
        if (this.userList() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property userList in model BmcKeySetProperties"));
        }
        this.userList().forEach(e -> e.validate());
        if (this.userListStatus() != null) {
            this.userListStatus().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("azureGroupId", this.azureGroupId);
        jsonWriter.writeStringField("expiration", this.expiration == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiration));
        jsonWriter.writeStringField("privilegeLevel", this.privilegeLevel == null ? null : this.privilegeLevel.toString());
        jsonWriter.writeArrayField("userList", this.userList, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BmcKeySetProperties fromJson(JsonReader jsonReader) throws IOException {
        return (BmcKeySetProperties)jsonReader.readObject(reader -> {
            BmcKeySetProperties deserializedBmcKeySetProperties = new BmcKeySetProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("azureGroupId".equals(fieldName)) {
                    deserializedBmcKeySetProperties.azureGroupId = reader.getString();
                    continue;
                }
                if ("expiration".equals(fieldName)) {
                    deserializedBmcKeySetProperties.expiration = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("privilegeLevel".equals(fieldName)) {
                    deserializedBmcKeySetProperties.privilegeLevel = BmcKeySetPrivilegeLevel.fromString(reader.getString());
                    continue;
                }
                if ("userList".equals(fieldName)) {
                    List userList;
                    deserializedBmcKeySetProperties.userList = userList = reader.readArray(reader1 -> KeySetUser.fromJson(reader1));
                    continue;
                }
                if ("detailedStatus".equals(fieldName)) {
                    deserializedBmcKeySetProperties.detailedStatus = BmcKeySetDetailedStatus.fromString(reader.getString());
                    continue;
                }
                if ("detailedStatusMessage".equals(fieldName)) {
                    deserializedBmcKeySetProperties.detailedStatusMessage = reader.getString();
                    continue;
                }
                if ("lastValidation".equals(fieldName)) {
                    deserializedBmcKeySetProperties.lastValidation = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedBmcKeySetProperties.provisioningState = BmcKeySetProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("userListStatus".equals(fieldName)) {
                    List userListStatus;
                    deserializedBmcKeySetProperties.userListStatus = userListStatus = reader.readArray(reader1 -> KeySetUserStatus.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBmcKeySetProperties;
        });
    }
}

