/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineKeySetDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineKeySetPrivilegeLevel;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineKeySetProvisioningState;
import com.azure.resourcemanager.networkcloud.models.KeySetUser;
import com.azure.resourcemanager.networkcloud.models.KeySetUserStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class BareMetalMachineKeySetProperties
implements JsonSerializable<BareMetalMachineKeySetProperties> {
    private String azureGroupId;
    private BareMetalMachineKeySetDetailedStatus detailedStatus;
    private String detailedStatusMessage;
    private OffsetDateTime expiration;
    private List<String> jumpHostsAllowed;
    private OffsetDateTime lastValidation;
    private String osGroupName;
    private BareMetalMachineKeySetPrivilegeLevel privilegeLevel;
    private BareMetalMachineKeySetProvisioningState provisioningState;
    private List<KeySetUser> userList;
    private List<KeySetUserStatus> userListStatus;
    private static final ClientLogger LOGGER = new ClientLogger(BareMetalMachineKeySetProperties.class);

    public String azureGroupId() {
        return this.azureGroupId;
    }

    public BareMetalMachineKeySetProperties withAzureGroupId(String azureGroupId) {
        this.azureGroupId = azureGroupId;
        return this;
    }

    public BareMetalMachineKeySetDetailedStatus detailedStatus() {
        return this.detailedStatus;
    }

    public String detailedStatusMessage() {
        return this.detailedStatusMessage;
    }

    public OffsetDateTime expiration() {
        return this.expiration;
    }

    public BareMetalMachineKeySetProperties withExpiration(OffsetDateTime expiration) {
        this.expiration = expiration;
        return this;
    }

    public List<String> jumpHostsAllowed() {
        return this.jumpHostsAllowed;
    }

    public BareMetalMachineKeySetProperties withJumpHostsAllowed(List<String> jumpHostsAllowed) {
        this.jumpHostsAllowed = jumpHostsAllowed;
        return this;
    }

    public OffsetDateTime lastValidation() {
        return this.lastValidation;
    }

    public String osGroupName() {
        return this.osGroupName;
    }

    public BareMetalMachineKeySetProperties withOsGroupName(String osGroupName) {
        this.osGroupName = osGroupName;
        return this;
    }

    public BareMetalMachineKeySetPrivilegeLevel privilegeLevel() {
        return this.privilegeLevel;
    }

    public BareMetalMachineKeySetProperties withPrivilegeLevel(BareMetalMachineKeySetPrivilegeLevel privilegeLevel) {
        this.privilegeLevel = privilegeLevel;
        return this;
    }

    public BareMetalMachineKeySetProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<KeySetUser> userList() {
        return this.userList;
    }

    public BareMetalMachineKeySetProperties withUserList(List<KeySetUser> userList) {
        this.userList = userList;
        return this;
    }

    public List<KeySetUserStatus> userListStatus() {
        return this.userListStatus;
    }

    public void validate() {
        if (this.azureGroupId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property azureGroupId in model BareMetalMachineKeySetProperties"));
        }
        if (this.expiration() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property expiration in model BareMetalMachineKeySetProperties"));
        }
        if (this.jumpHostsAllowed() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property jumpHostsAllowed in model BareMetalMachineKeySetProperties"));
        }
        if (this.privilegeLevel() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property privilegeLevel in model BareMetalMachineKeySetProperties"));
        }
        if (this.userList() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property userList in model BareMetalMachineKeySetProperties"));
        }
        this.userList().forEach(e -> e.validate());
        if (this.userListStatus() != null) {
            this.userListStatus().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("azureGroupId", this.azureGroupId);
        jsonWriter.writeStringField("expiration", this.expiration == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiration));
        jsonWriter.writeArrayField("jumpHostsAllowed", this.jumpHostsAllowed, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("privilegeLevel", this.privilegeLevel == null ? null : this.privilegeLevel.toString());
        jsonWriter.writeArrayField("userList", this.userList, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("osGroupName", this.osGroupName);
        return jsonWriter.writeEndObject();
    }

    public static BareMetalMachineKeySetProperties fromJson(JsonReader jsonReader) throws IOException {
        return (BareMetalMachineKeySetProperties)jsonReader.readObject(reader -> {
            BareMetalMachineKeySetProperties deserializedBareMetalMachineKeySetProperties = new BareMetalMachineKeySetProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("azureGroupId".equals(fieldName)) {
                    deserializedBareMetalMachineKeySetProperties.azureGroupId = reader.getString();
                    continue;
                }
                if ("expiration".equals(fieldName)) {
                    deserializedBareMetalMachineKeySetProperties.expiration = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("jumpHostsAllowed".equals(fieldName)) {
                    List jumpHostsAllowed;
                    deserializedBareMetalMachineKeySetProperties.jumpHostsAllowed = jumpHostsAllowed = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("privilegeLevel".equals(fieldName)) {
                    deserializedBareMetalMachineKeySetProperties.privilegeLevel = BareMetalMachineKeySetPrivilegeLevel.fromString(reader.getString());
                    continue;
                }
                if ("userList".equals(fieldName)) {
                    List userList;
                    deserializedBareMetalMachineKeySetProperties.userList = userList = reader.readArray(reader1 -> KeySetUser.fromJson(reader1));
                    continue;
                }
                if ("detailedStatus".equals(fieldName)) {
                    deserializedBareMetalMachineKeySetProperties.detailedStatus = BareMetalMachineKeySetDetailedStatus.fromString(reader.getString());
                    continue;
                }
                if ("detailedStatusMessage".equals(fieldName)) {
                    deserializedBareMetalMachineKeySetProperties.detailedStatusMessage = reader.getString();
                    continue;
                }
                if ("lastValidation".equals(fieldName)) {
                    deserializedBareMetalMachineKeySetProperties.lastValidation = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("osGroupName".equals(fieldName)) {
                    deserializedBareMetalMachineKeySetProperties.osGroupName = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedBareMetalMachineKeySetProperties.provisioningState = BareMetalMachineKeySetProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("userListStatus".equals(fieldName)) {
                    List userListStatus;
                    deserializedBareMetalMachineKeySetProperties.userListStatus = userListStatus = reader.readArray(reader1 -> KeySetUserStatus.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBareMetalMachineKeySetProperties;
        });
    }
}

