/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.AdministratorConfiguration;
import com.azure.resourcemanager.networkcloud.models.AgentOptions;
import com.azure.resourcemanager.networkcloud.models.AgentPoolDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.AgentPoolMode;
import com.azure.resourcemanager.networkcloud.models.AgentPoolProvisioningState;
import com.azure.resourcemanager.networkcloud.models.AgentPoolUpgradeSettings;
import com.azure.resourcemanager.networkcloud.models.AttachedNetworkConfiguration;
import com.azure.resourcemanager.networkcloud.models.KubernetesLabel;
import java.io.IOException;
import java.util.List;

public final class AgentPoolProperties
implements JsonSerializable<AgentPoolProperties> {
    private AdministratorConfiguration administratorConfiguration;
    private AgentOptions agentOptions;
    private AttachedNetworkConfiguration attachedNetworkConfiguration;
    private List<String> availabilityZones;
    private long count;
    private AgentPoolDetailedStatus detailedStatus;
    private String detailedStatusMessage;
    private String kubernetesVersion;
    private List<KubernetesLabel> labels;
    private AgentPoolMode mode;
    private AgentPoolProvisioningState provisioningState;
    private List<KubernetesLabel> taints;
    private AgentPoolUpgradeSettings upgradeSettings;
    private String vmSkuName;
    private static final ClientLogger LOGGER = new ClientLogger(AgentPoolProperties.class);

    public AdministratorConfiguration administratorConfiguration() {
        return this.administratorConfiguration;
    }

    public AgentPoolProperties withAdministratorConfiguration(AdministratorConfiguration administratorConfiguration) {
        this.administratorConfiguration = administratorConfiguration;
        return this;
    }

    public AgentOptions agentOptions() {
        return this.agentOptions;
    }

    public AgentPoolProperties withAgentOptions(AgentOptions agentOptions) {
        this.agentOptions = agentOptions;
        return this;
    }

    public AttachedNetworkConfiguration attachedNetworkConfiguration() {
        return this.attachedNetworkConfiguration;
    }

    public AgentPoolProperties withAttachedNetworkConfiguration(AttachedNetworkConfiguration attachedNetworkConfiguration) {
        this.attachedNetworkConfiguration = attachedNetworkConfiguration;
        return this;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public AgentPoolProperties withAvailabilityZones(List<String> availabilityZones) {
        this.availabilityZones = availabilityZones;
        return this;
    }

    public long count() {
        return this.count;
    }

    public AgentPoolProperties withCount(long count) {
        this.count = count;
        return this;
    }

    public AgentPoolDetailedStatus detailedStatus() {
        return this.detailedStatus;
    }

    public String detailedStatusMessage() {
        return this.detailedStatusMessage;
    }

    public String kubernetesVersion() {
        return this.kubernetesVersion;
    }

    public List<KubernetesLabel> labels() {
        return this.labels;
    }

    public AgentPoolProperties withLabels(List<KubernetesLabel> labels) {
        this.labels = labels;
        return this;
    }

    public AgentPoolMode mode() {
        return this.mode;
    }

    public AgentPoolProperties withMode(AgentPoolMode mode) {
        this.mode = mode;
        return this;
    }

    public AgentPoolProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<KubernetesLabel> taints() {
        return this.taints;
    }

    public AgentPoolProperties withTaints(List<KubernetesLabel> taints) {
        this.taints = taints;
        return this;
    }

    public AgentPoolUpgradeSettings upgradeSettings() {
        return this.upgradeSettings;
    }

    public AgentPoolProperties withUpgradeSettings(AgentPoolUpgradeSettings upgradeSettings) {
        this.upgradeSettings = upgradeSettings;
        return this;
    }

    public String vmSkuName() {
        return this.vmSkuName;
    }

    public AgentPoolProperties withVmSkuName(String vmSkuName) {
        this.vmSkuName = vmSkuName;
        return this;
    }

    public void validate() {
        if (this.administratorConfiguration() != null) {
            this.administratorConfiguration().validate();
        }
        if (this.agentOptions() != null) {
            this.agentOptions().validate();
        }
        if (this.attachedNetworkConfiguration() != null) {
            this.attachedNetworkConfiguration().validate();
        }
        if (this.labels() != null) {
            this.labels().forEach(e -> e.validate());
        }
        if (this.mode() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property mode in model AgentPoolProperties"));
        }
        if (this.taints() != null) {
            this.taints().forEach(e -> e.validate());
        }
        if (this.upgradeSettings() != null) {
            this.upgradeSettings().validate();
        }
        if (this.vmSkuName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property vmSkuName in model AgentPoolProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeLongField("count", this.count);
        jsonWriter.writeStringField("mode", this.mode == null ? null : this.mode.toString());
        jsonWriter.writeStringField("vmSkuName", this.vmSkuName);
        jsonWriter.writeJsonField("administratorConfiguration", (JsonSerializable)this.administratorConfiguration);
        jsonWriter.writeJsonField("agentOptions", (JsonSerializable)this.agentOptions);
        jsonWriter.writeJsonField("attachedNetworkConfiguration", (JsonSerializable)this.attachedNetworkConfiguration);
        jsonWriter.writeArrayField("availabilityZones", this.availabilityZones, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("labels", this.labels, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("taints", this.taints, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("upgradeSettings", (JsonSerializable)this.upgradeSettings);
        return jsonWriter.writeEndObject();
    }

    public static AgentPoolProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AgentPoolProperties)jsonReader.readObject(reader -> {
            AgentPoolProperties deserializedAgentPoolProperties = new AgentPoolProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("count".equals(fieldName)) {
                    deserializedAgentPoolProperties.count = reader.getLong();
                    continue;
                }
                if ("mode".equals(fieldName)) {
                    deserializedAgentPoolProperties.mode = AgentPoolMode.fromString(reader.getString());
                    continue;
                }
                if ("vmSkuName".equals(fieldName)) {
                    deserializedAgentPoolProperties.vmSkuName = reader.getString();
                    continue;
                }
                if ("administratorConfiguration".equals(fieldName)) {
                    deserializedAgentPoolProperties.administratorConfiguration = AdministratorConfiguration.fromJson(reader);
                    continue;
                }
                if ("agentOptions".equals(fieldName)) {
                    deserializedAgentPoolProperties.agentOptions = AgentOptions.fromJson(reader);
                    continue;
                }
                if ("attachedNetworkConfiguration".equals(fieldName)) {
                    deserializedAgentPoolProperties.attachedNetworkConfiguration = AttachedNetworkConfiguration.fromJson(reader);
                    continue;
                }
                if ("availabilityZones".equals(fieldName)) {
                    List availabilityZones;
                    deserializedAgentPoolProperties.availabilityZones = availabilityZones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("detailedStatus".equals(fieldName)) {
                    deserializedAgentPoolProperties.detailedStatus = AgentPoolDetailedStatus.fromString(reader.getString());
                    continue;
                }
                if ("detailedStatusMessage".equals(fieldName)) {
                    deserializedAgentPoolProperties.detailedStatusMessage = reader.getString();
                    continue;
                }
                if ("kubernetesVersion".equals(fieldName)) {
                    deserializedAgentPoolProperties.kubernetesVersion = reader.getString();
                    continue;
                }
                if ("labels".equals(fieldName)) {
                    List labels;
                    deserializedAgentPoolProperties.labels = labels = reader.readArray(reader1 -> KubernetesLabel.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedAgentPoolProperties.provisioningState = AgentPoolProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("taints".equals(fieldName)) {
                    List taints;
                    deserializedAgentPoolProperties.taints = taints = reader.readArray(reader1 -> KubernetesLabel.fromJson(reader1));
                    continue;
                }
                if ("upgradeSettings".equals(fieldName)) {
                    deserializedAgentPoolProperties.upgradeSettings = AgentPoolUpgradeSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAgentPoolProperties;
        });
    }
}

