/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.VirtualMachinePlacementHintPodAffinityScope;
import com.azure.resourcemanager.networkcloud.models.VirtualMachinePlacementHintType;
import com.azure.resourcemanager.networkcloud.models.VirtualMachineSchedulingExecution;
import java.io.IOException;

public final class VirtualMachinePlacementHint
implements JsonSerializable<VirtualMachinePlacementHint> {
    private VirtualMachinePlacementHintType hintType;
    private String resourceId;
    private VirtualMachineSchedulingExecution schedulingExecution;
    private VirtualMachinePlacementHintPodAffinityScope scope;
    private static final ClientLogger LOGGER = new ClientLogger(VirtualMachinePlacementHint.class);

    public VirtualMachinePlacementHintType hintType() {
        return this.hintType;
    }

    public VirtualMachinePlacementHint withHintType(VirtualMachinePlacementHintType hintType) {
        this.hintType = hintType;
        return this;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public VirtualMachinePlacementHint withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public VirtualMachineSchedulingExecution schedulingExecution() {
        return this.schedulingExecution;
    }

    public VirtualMachinePlacementHint withSchedulingExecution(VirtualMachineSchedulingExecution schedulingExecution) {
        this.schedulingExecution = schedulingExecution;
        return this;
    }

    public VirtualMachinePlacementHintPodAffinityScope scope() {
        return this.scope;
    }

    public VirtualMachinePlacementHint withScope(VirtualMachinePlacementHintPodAffinityScope scope) {
        this.scope = scope;
        return this;
    }

    public void validate() {
        if (this.hintType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property hintType in model VirtualMachinePlacementHint"));
        }
        if (this.resourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resourceId in model VirtualMachinePlacementHint"));
        }
        if (this.schedulingExecution() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property schedulingExecution in model VirtualMachinePlacementHint"));
        }
        if (this.scope() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property scope in model VirtualMachinePlacementHint"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("hintType", this.hintType == null ? null : this.hintType.toString());
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("schedulingExecution", this.schedulingExecution == null ? null : this.schedulingExecution.toString());
        jsonWriter.writeStringField("scope", this.scope == null ? null : this.scope.toString());
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachinePlacementHint fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachinePlacementHint)jsonReader.readObject(reader -> {
            VirtualMachinePlacementHint deserializedVirtualMachinePlacementHint = new VirtualMachinePlacementHint();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("hintType".equals(fieldName)) {
                    deserializedVirtualMachinePlacementHint.hintType = VirtualMachinePlacementHintType.fromString(reader.getString());
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    deserializedVirtualMachinePlacementHint.resourceId = reader.getString();
                    continue;
                }
                if ("schedulingExecution".equals(fieldName)) {
                    deserializedVirtualMachinePlacementHint.schedulingExecution = VirtualMachineSchedulingExecution.fromString(reader.getString());
                    continue;
                }
                if ("scope".equals(fieldName)) {
                    deserializedVirtualMachinePlacementHint.scope = VirtualMachinePlacementHintPodAffinityScope.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachinePlacementHint;
        });
    }
}

