/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.KubernetesPluginType;
import java.io.IOException;

public final class TrunkedNetworkAttachmentConfiguration
implements JsonSerializable<TrunkedNetworkAttachmentConfiguration> {
    private String networkId;
    private KubernetesPluginType pluginType;
    private static final ClientLogger LOGGER = new ClientLogger(TrunkedNetworkAttachmentConfiguration.class);

    public String networkId() {
        return this.networkId;
    }

    public TrunkedNetworkAttachmentConfiguration withNetworkId(String networkId) {
        this.networkId = networkId;
        return this;
    }

    public KubernetesPluginType pluginType() {
        return this.pluginType;
    }

    public TrunkedNetworkAttachmentConfiguration withPluginType(KubernetesPluginType pluginType) {
        this.pluginType = pluginType;
        return this;
    }

    public void validate() {
        if (this.networkId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property networkId in model TrunkedNetworkAttachmentConfiguration"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("networkId", this.networkId);
        jsonWriter.writeStringField("pluginType", this.pluginType == null ? null : this.pluginType.toString());
        return jsonWriter.writeEndObject();
    }

    public static TrunkedNetworkAttachmentConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (TrunkedNetworkAttachmentConfiguration)jsonReader.readObject(reader -> {
            TrunkedNetworkAttachmentConfiguration deserializedTrunkedNetworkAttachmentConfiguration = new TrunkedNetworkAttachmentConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("networkId".equals(fieldName)) {
                    deserializedTrunkedNetworkAttachmentConfiguration.networkId = reader.getString();
                    continue;
                }
                if ("pluginType".equals(fieldName)) {
                    deserializedTrunkedNetworkAttachmentConfiguration.pluginType = KubernetesPluginType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTrunkedNetworkAttachmentConfiguration;
        });
    }
}

