/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.StorageApplianceInner;
import java.io.IOException;
import java.util.List;

public final class StorageApplianceList
implements JsonSerializable<StorageApplianceList> {
    private String nextLink;
    private List<StorageApplianceInner> value;

    public String nextLink() {
        return this.nextLink;
    }

    public StorageApplianceList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public List<StorageApplianceInner> value() {
        return this.value;
    }

    public StorageApplianceList withValue(List<StorageApplianceInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static StorageApplianceList fromJson(JsonReader jsonReader) throws IOException {
        return (StorageApplianceList)jsonReader.readObject(reader -> {
            StorageApplianceList deserializedStorageApplianceList = new StorageApplianceList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedStorageApplianceList.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedStorageApplianceList.value = value = reader.readArray(reader1 -> StorageApplianceInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageApplianceList;
        });
    }
}

