/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.AdministrativeCredentials;
import java.io.IOException;

public final class StorageApplianceConfigurationData
implements JsonSerializable<StorageApplianceConfigurationData> {
    private AdministrativeCredentials adminCredentials;
    private long rackSlot;
    private String serialNumber;
    private String storageApplianceName;
    private static final ClientLogger LOGGER = new ClientLogger(StorageApplianceConfigurationData.class);

    public AdministrativeCredentials adminCredentials() {
        return this.adminCredentials;
    }

    public StorageApplianceConfigurationData withAdminCredentials(AdministrativeCredentials adminCredentials) {
        this.adminCredentials = adminCredentials;
        return this;
    }

    public long rackSlot() {
        return this.rackSlot;
    }

    public StorageApplianceConfigurationData withRackSlot(long rackSlot) {
        this.rackSlot = rackSlot;
        return this;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public StorageApplianceConfigurationData withSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    public String storageApplianceName() {
        return this.storageApplianceName;
    }

    public StorageApplianceConfigurationData withStorageApplianceName(String storageApplianceName) {
        this.storageApplianceName = storageApplianceName;
        return this;
    }

    public void validate() {
        if (this.adminCredentials() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property adminCredentials in model StorageApplianceConfigurationData"));
        }
        this.adminCredentials().validate();
        if (this.serialNumber() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property serialNumber in model StorageApplianceConfigurationData"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("adminCredentials", (JsonSerializable)this.adminCredentials);
        jsonWriter.writeLongField("rackSlot", this.rackSlot);
        jsonWriter.writeStringField("serialNumber", this.serialNumber);
        jsonWriter.writeStringField("storageApplianceName", this.storageApplianceName);
        return jsonWriter.writeEndObject();
    }

    public static StorageApplianceConfigurationData fromJson(JsonReader jsonReader) throws IOException {
        return (StorageApplianceConfigurationData)jsonReader.readObject(reader -> {
            StorageApplianceConfigurationData deserializedStorageApplianceConfigurationData = new StorageApplianceConfigurationData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("adminCredentials".equals(fieldName)) {
                    deserializedStorageApplianceConfigurationData.adminCredentials = AdministrativeCredentials.fromJson(reader);
                    continue;
                }
                if ("rackSlot".equals(fieldName)) {
                    deserializedStorageApplianceConfigurationData.rackSlot = reader.getLong();
                    continue;
                }
                if ("serialNumber".equals(fieldName)) {
                    deserializedStorageApplianceConfigurationData.serialNumber = reader.getString();
                    continue;
                }
                if ("storageApplianceName".equals(fieldName)) {
                    deserializedStorageApplianceConfigurationData.storageApplianceName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageApplianceConfigurationData;
        });
    }
}

