/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.IdentitySelector;
import java.io.IOException;

public final class SecretArchiveSettings
implements JsonSerializable<SecretArchiveSettings> {
    private IdentitySelector associatedIdentity;
    private String vaultUri;

    public IdentitySelector associatedIdentity() {
        return this.associatedIdentity;
    }

    public SecretArchiveSettings withAssociatedIdentity(IdentitySelector associatedIdentity) {
        this.associatedIdentity = associatedIdentity;
        return this;
    }

    public String vaultUri() {
        return this.vaultUri;
    }

    public SecretArchiveSettings withVaultUri(String vaultUri) {
        this.vaultUri = vaultUri;
        return this;
    }

    public void validate() {
        if (this.associatedIdentity() != null) {
            this.associatedIdentity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("associatedIdentity", (JsonSerializable)this.associatedIdentity);
        jsonWriter.writeStringField("vaultUri", this.vaultUri);
        return jsonWriter.writeEndObject();
    }

    public static SecretArchiveSettings fromJson(JsonReader jsonReader) throws IOException {
        return (SecretArchiveSettings)jsonReader.readObject(reader -> {
            SecretArchiveSettings deserializedSecretArchiveSettings = new SecretArchiveSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("associatedIdentity".equals(fieldName)) {
                    deserializedSecretArchiveSettings.associatedIdentity = IdentitySelector.fromJson(reader);
                    continue;
                }
                if ("vaultUri".equals(fieldName)) {
                    deserializedSecretArchiveSettings.vaultUri = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecretArchiveSettings;
        });
    }
}

