/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.DefaultGateway;
import com.azure.resourcemanager.networkcloud.models.VirtualMachineIpAllocationMethod;
import java.io.IOException;

public final class NetworkAttachment
implements JsonSerializable<NetworkAttachment> {
    private String attachedNetworkId;
    private DefaultGateway defaultGateway;
    private VirtualMachineIpAllocationMethod ipAllocationMethod;
    private String ipv4Address;
    private String ipv6Address;
    private String macAddress;
    private String networkAttachmentName;
    private static final ClientLogger LOGGER = new ClientLogger(NetworkAttachment.class);

    public String attachedNetworkId() {
        return this.attachedNetworkId;
    }

    public NetworkAttachment withAttachedNetworkId(String attachedNetworkId) {
        this.attachedNetworkId = attachedNetworkId;
        return this;
    }

    public DefaultGateway defaultGateway() {
        return this.defaultGateway;
    }

    public NetworkAttachment withDefaultGateway(DefaultGateway defaultGateway) {
        this.defaultGateway = defaultGateway;
        return this;
    }

    public VirtualMachineIpAllocationMethod ipAllocationMethod() {
        return this.ipAllocationMethod;
    }

    public NetworkAttachment withIpAllocationMethod(VirtualMachineIpAllocationMethod ipAllocationMethod) {
        this.ipAllocationMethod = ipAllocationMethod;
        return this;
    }

    public String ipv4Address() {
        return this.ipv4Address;
    }

    public NetworkAttachment withIpv4Address(String ipv4Address) {
        this.ipv4Address = ipv4Address;
        return this;
    }

    public String ipv6Address() {
        return this.ipv6Address;
    }

    public NetworkAttachment withIpv6Address(String ipv6Address) {
        this.ipv6Address = ipv6Address;
        return this;
    }

    public String macAddress() {
        return this.macAddress;
    }

    public String networkAttachmentName() {
        return this.networkAttachmentName;
    }

    public NetworkAttachment withNetworkAttachmentName(String networkAttachmentName) {
        this.networkAttachmentName = networkAttachmentName;
        return this;
    }

    public void validate() {
        if (this.attachedNetworkId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property attachedNetworkId in model NetworkAttachment"));
        }
        if (this.ipAllocationMethod() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property ipAllocationMethod in model NetworkAttachment"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("attachedNetworkId", this.attachedNetworkId);
        jsonWriter.writeStringField("ipAllocationMethod", this.ipAllocationMethod == null ? null : this.ipAllocationMethod.toString());
        jsonWriter.writeStringField("defaultGateway", this.defaultGateway == null ? null : this.defaultGateway.toString());
        jsonWriter.writeStringField("ipv4Address", this.ipv4Address);
        jsonWriter.writeStringField("ipv6Address", this.ipv6Address);
        jsonWriter.writeStringField("networkAttachmentName", this.networkAttachmentName);
        return jsonWriter.writeEndObject();
    }

    public static NetworkAttachment fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkAttachment)jsonReader.readObject(reader -> {
            NetworkAttachment deserializedNetworkAttachment = new NetworkAttachment();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("attachedNetworkId".equals(fieldName)) {
                    deserializedNetworkAttachment.attachedNetworkId = reader.getString();
                    continue;
                }
                if ("ipAllocationMethod".equals(fieldName)) {
                    deserializedNetworkAttachment.ipAllocationMethod = VirtualMachineIpAllocationMethod.fromString(reader.getString());
                    continue;
                }
                if ("defaultGateway".equals(fieldName)) {
                    deserializedNetworkAttachment.defaultGateway = DefaultGateway.fromString(reader.getString());
                    continue;
                }
                if ("ipv4Address".equals(fieldName)) {
                    deserializedNetworkAttachment.ipv4Address = reader.getString();
                    continue;
                }
                if ("ipv6Address".equals(fieldName)) {
                    deserializedNetworkAttachment.ipv6Address = reader.getString();
                    continue;
                }
                if ("macAddress".equals(fieldName)) {
                    deserializedNetworkAttachment.macAddress = reader.getString();
                    continue;
                }
                if ("networkAttachmentName".equals(fieldName)) {
                    deserializedNetworkAttachment.networkAttachmentName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkAttachment;
        });
    }
}

