/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.L3NetworkInner;
import java.io.IOException;
import java.util.List;

public final class L3NetworkList
implements JsonSerializable<L3NetworkList> {
    private String nextLink;
    private List<L3NetworkInner> value;

    public String nextLink() {
        return this.nextLink;
    }

    public L3NetworkList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public List<L3NetworkInner> value() {
        return this.value;
    }

    public L3NetworkList withValue(List<L3NetworkInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static L3NetworkList fromJson(JsonReader jsonReader) throws IOException {
        return (L3NetworkList)jsonReader.readObject(reader -> {
            L3NetworkList deserializedL3NetworkList = new L3NetworkList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedL3NetworkList.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedL3NetworkList.value = value = reader.readArray(reader1 -> L3NetworkInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedL3NetworkList;
        });
    }
}

