/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.fluent.models.KubernetesClusterFeatureInner;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterFeatureAvailabilityLifecycle;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterFeatureDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterFeatureProvisioningState;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterFeatureRequired;
import com.azure.resourcemanager.networkcloud.models.StringKeyValuePair;
import java.util.List;
import java.util.Map;

public interface KubernetesClusterFeature {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public SystemData systemData();

    public KubernetesClusterFeatureAvailabilityLifecycle availabilityLifecycle();

    public KubernetesClusterFeatureDetailedStatus detailedStatus();

    public String detailedStatusMessage();

    public List<StringKeyValuePair> options();

    public KubernetesClusterFeatureProvisioningState provisioningState();

    public KubernetesClusterFeatureRequired required();

    public String version();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public KubernetesClusterFeatureInner innerModel();

    public Update update();

    public KubernetesClusterFeature refresh();

    public KubernetesClusterFeature refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithOptions {
            public Update withOptions(List<StringKeyValuePair> var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithOptions {
        public KubernetesClusterFeature apply();

        public KubernetesClusterFeature apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithOptions {
            public WithCreate withOptions(List<StringKeyValuePair> var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithOptions {
            public KubernetesClusterFeature create();

            public KubernetesClusterFeature create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingKubernetesCluster(String var1, String var2);
        }

        public static interface WithLocation {
            public WithParentResource withRegion(Region var1);

            public WithParentResource withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

