/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.SshPublicKey;
import java.io.IOException;

public final class KeySetUser
implements JsonSerializable<KeySetUser> {
    private String azureUsername;
    private String description;
    private SshPublicKey sshPublicKey;
    private String userPrincipalName;
    private static final ClientLogger LOGGER = new ClientLogger(KeySetUser.class);

    public String azureUsername() {
        return this.azureUsername;
    }

    public KeySetUser withAzureUsername(String azureUsername) {
        this.azureUsername = azureUsername;
        return this;
    }

    public String description() {
        return this.description;
    }

    public KeySetUser withDescription(String description) {
        this.description = description;
        return this;
    }

    public SshPublicKey sshPublicKey() {
        return this.sshPublicKey;
    }

    public KeySetUser withSshPublicKey(SshPublicKey sshPublicKey) {
        this.sshPublicKey = sshPublicKey;
        return this;
    }

    public String userPrincipalName() {
        return this.userPrincipalName;
    }

    public KeySetUser withUserPrincipalName(String userPrincipalName) {
        this.userPrincipalName = userPrincipalName;
        return this;
    }

    public void validate() {
        if (this.azureUsername() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property azureUsername in model KeySetUser"));
        }
        if (this.sshPublicKey() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sshPublicKey in model KeySetUser"));
        }
        this.sshPublicKey().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("azureUserName", this.azureUsername);
        jsonWriter.writeJsonField("sshPublicKey", (JsonSerializable)this.sshPublicKey);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("userPrincipalName", this.userPrincipalName);
        return jsonWriter.writeEndObject();
    }

    public static KeySetUser fromJson(JsonReader jsonReader) throws IOException {
        return (KeySetUser)jsonReader.readObject(reader -> {
            KeySetUser deserializedKeySetUser = new KeySetUser();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("azureUserName".equals(fieldName)) {
                    deserializedKeySetUser.azureUsername = reader.getString();
                    continue;
                }
                if ("sshPublicKey".equals(fieldName)) {
                    deserializedKeySetUser.sshPublicKey = SshPublicKey.fromJson(reader);
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedKeySetUser.description = reader.getString();
                    continue;
                }
                if ("userPrincipalName".equals(fieldName)) {
                    deserializedKeySetUser.userPrincipalName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeySetUser;
        });
    }
}

