/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ImageRepositoryCredentials
implements JsonSerializable<ImageRepositoryCredentials> {
    private String password;
    private String registryUrl;
    private String username;
    private static final ClientLogger LOGGER = new ClientLogger(ImageRepositoryCredentials.class);

    public String password() {
        return this.password;
    }

    public ImageRepositoryCredentials withPassword(String password) {
        this.password = password;
        return this;
    }

    public String registryUrl() {
        return this.registryUrl;
    }

    public ImageRepositoryCredentials withRegistryUrl(String registryUrl) {
        this.registryUrl = registryUrl;
        return this;
    }

    public String username() {
        return this.username;
    }

    public ImageRepositoryCredentials withUsername(String username) {
        this.username = username;
        return this;
    }

    public void validate() {
        if (this.password() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property password in model ImageRepositoryCredentials"));
        }
        if (this.registryUrl() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property registryUrl in model ImageRepositoryCredentials"));
        }
        if (this.username() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property username in model ImageRepositoryCredentials"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeStringField("registryUrl", this.registryUrl);
        jsonWriter.writeStringField("username", this.username);
        return jsonWriter.writeEndObject();
    }

    public static ImageRepositoryCredentials fromJson(JsonReader jsonReader) throws IOException {
        return (ImageRepositoryCredentials)jsonReader.readObject(reader -> {
            ImageRepositoryCredentials deserializedImageRepositoryCredentials = new ImageRepositoryCredentials();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("password".equals(fieldName)) {
                    deserializedImageRepositoryCredentials.password = reader.getString();
                    continue;
                }
                if ("registryUrl".equals(fieldName)) {
                    deserializedImageRepositoryCredentials.registryUrl = reader.getString();
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedImageRepositoryCredentials.username = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedImageRepositoryCredentials;
        });
    }
}

