/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.ConsoleInner;
import java.io.IOException;
import java.util.List;

public final class ConsoleList
implements JsonSerializable<ConsoleList> {
    private String nextLink;
    private List<ConsoleInner> value;

    public String nextLink() {
        return this.nextLink;
    }

    public ConsoleList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public List<ConsoleInner> value() {
        return this.value;
    }

    public ConsoleList withValue(List<ConsoleInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ConsoleList fromJson(JsonReader jsonReader) throws IOException {
        return (ConsoleList)jsonReader.readObject(reader -> {
            ConsoleList deserializedConsoleList = new ConsoleList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedConsoleList.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedConsoleList.value = value = reader.readArray(reader1 -> ConsoleInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConsoleList;
        });
    }
}

