/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.ClusterUpdateStrategyType;
import com.azure.resourcemanager.networkcloud.models.ValidationThresholdType;
import java.io.IOException;

public final class ClusterUpdateStrategy
implements JsonSerializable<ClusterUpdateStrategy> {
    private Long maxUnavailable;
    private ClusterUpdateStrategyType strategyType;
    private ValidationThresholdType thresholdType;
    private long thresholdValue;
    private Long waitTimeMinutes;
    private static final ClientLogger LOGGER = new ClientLogger(ClusterUpdateStrategy.class);

    public Long maxUnavailable() {
        return this.maxUnavailable;
    }

    public ClusterUpdateStrategy withMaxUnavailable(Long maxUnavailable) {
        this.maxUnavailable = maxUnavailable;
        return this;
    }

    public ClusterUpdateStrategyType strategyType() {
        return this.strategyType;
    }

    public ClusterUpdateStrategy withStrategyType(ClusterUpdateStrategyType strategyType) {
        this.strategyType = strategyType;
        return this;
    }

    public ValidationThresholdType thresholdType() {
        return this.thresholdType;
    }

    public ClusterUpdateStrategy withThresholdType(ValidationThresholdType thresholdType) {
        this.thresholdType = thresholdType;
        return this;
    }

    public long thresholdValue() {
        return this.thresholdValue;
    }

    public ClusterUpdateStrategy withThresholdValue(long thresholdValue) {
        this.thresholdValue = thresholdValue;
        return this;
    }

    public Long waitTimeMinutes() {
        return this.waitTimeMinutes;
    }

    public ClusterUpdateStrategy withWaitTimeMinutes(Long waitTimeMinutes) {
        this.waitTimeMinutes = waitTimeMinutes;
        return this;
    }

    public void validate() {
        if (this.strategyType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property strategyType in model ClusterUpdateStrategy"));
        }
        if (this.thresholdType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property thresholdType in model ClusterUpdateStrategy"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("strategyType", this.strategyType == null ? null : this.strategyType.toString());
        jsonWriter.writeStringField("thresholdType", this.thresholdType == null ? null : this.thresholdType.toString());
        jsonWriter.writeLongField("thresholdValue", this.thresholdValue);
        jsonWriter.writeNumberField("maxUnavailable", (Number)this.maxUnavailable);
        jsonWriter.writeNumberField("waitTimeMinutes", (Number)this.waitTimeMinutes);
        return jsonWriter.writeEndObject();
    }

    public static ClusterUpdateStrategy fromJson(JsonReader jsonReader) throws IOException {
        return (ClusterUpdateStrategy)jsonReader.readObject(reader -> {
            ClusterUpdateStrategy deserializedClusterUpdateStrategy = new ClusterUpdateStrategy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("strategyType".equals(fieldName)) {
                    deserializedClusterUpdateStrategy.strategyType = ClusterUpdateStrategyType.fromString(reader.getString());
                    continue;
                }
                if ("thresholdType".equals(fieldName)) {
                    deserializedClusterUpdateStrategy.thresholdType = ValidationThresholdType.fromString(reader.getString());
                    continue;
                }
                if ("thresholdValue".equals(fieldName)) {
                    deserializedClusterUpdateStrategy.thresholdValue = reader.getLong();
                    continue;
                }
                if ("maxUnavailable".equals(fieldName)) {
                    deserializedClusterUpdateStrategy.maxUnavailable = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("waitTimeMinutes".equals(fieldName)) {
                    deserializedClusterUpdateStrategy.waitTimeMinutes = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClusterUpdateStrategy;
        });
    }
}

