/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.ClusterMetricsConfigurationPatchProperties;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ClusterMetricsConfigurationPatchParameters
implements JsonSerializable<ClusterMetricsConfigurationPatchParameters> {
    private ClusterMetricsConfigurationPatchProperties innerProperties;
    private Map<String, String> tags;

    private ClusterMetricsConfigurationPatchProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ClusterMetricsConfigurationPatchParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Long collectionInterval() {
        return this.innerProperties() == null ? null : this.innerProperties().collectionInterval();
    }

    public ClusterMetricsConfigurationPatchParameters withCollectionInterval(Long collectionInterval) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterMetricsConfigurationPatchProperties();
        }
        this.innerProperties().withCollectionInterval(collectionInterval);
        return this;
    }

    public List<String> enabledMetrics() {
        return this.innerProperties() == null ? null : this.innerProperties().enabledMetrics();
    }

    public ClusterMetricsConfigurationPatchParameters withEnabledMetrics(List<String> enabledMetrics) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClusterMetricsConfigurationPatchProperties();
        }
        this.innerProperties().withEnabledMetrics(enabledMetrics);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ClusterMetricsConfigurationPatchParameters fromJson(JsonReader jsonReader) throws IOException {
        return (ClusterMetricsConfigurationPatchParameters)jsonReader.readObject(reader -> {
            ClusterMetricsConfigurationPatchParameters deserializedClusterMetricsConfigurationPatchParameters = new ClusterMetricsConfigurationPatchParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedClusterMetricsConfigurationPatchParameters.innerProperties = ClusterMetricsConfigurationPatchProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedClusterMetricsConfigurationPatchParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClusterMetricsConfigurationPatchParameters;
        });
    }
}

