/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.BareMetalMachinePatchProperties;
import java.io.IOException;
import java.util.Map;

public final class BareMetalMachinePatchParameters
implements JsonSerializable<BareMetalMachinePatchParameters> {
    private BareMetalMachinePatchProperties innerProperties;
    private Map<String, String> tags;

    private BareMetalMachinePatchProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public BareMetalMachinePatchParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String machineDetails() {
        return this.innerProperties() == null ? null : this.innerProperties().machineDetails();
    }

    public BareMetalMachinePatchParameters withMachineDetails(String machineDetails) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BareMetalMachinePatchProperties();
        }
        this.innerProperties().withMachineDetails(machineDetails);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static BareMetalMachinePatchParameters fromJson(JsonReader jsonReader) throws IOException {
        return (BareMetalMachinePatchParameters)jsonReader.readObject(reader -> {
            BareMetalMachinePatchParameters deserializedBareMetalMachinePatchParameters = new BareMetalMachinePatchParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedBareMetalMachinePatchParameters.innerProperties = BareMetalMachinePatchProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedBareMetalMachinePatchParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBareMetalMachinePatchParameters;
        });
    }
}

