/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.BareMetalMachineInner;
import java.io.IOException;
import java.util.List;

public final class BareMetalMachineList
implements JsonSerializable<BareMetalMachineList> {
    private String nextLink;
    private List<BareMetalMachineInner> value;

    public String nextLink() {
        return this.nextLink;
    }

    public BareMetalMachineList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public List<BareMetalMachineInner> value() {
        return this.value;
    }

    public BareMetalMachineList withValue(List<BareMetalMachineInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BareMetalMachineList fromJson(JsonReader jsonReader) throws IOException {
        return (BareMetalMachineList)jsonReader.readObject(reader -> {
            BareMetalMachineList deserializedBareMetalMachineList = new BareMetalMachineList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedBareMetalMachineList.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedBareMetalMachineList.value = value = reader.readArray(reader1 -> BareMetalMachineInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBareMetalMachineList;
        });
    }
}

