/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.HugepagesSize;
import java.io.IOException;

public final class AgentOptions
implements JsonSerializable<AgentOptions> {
    private long hugepagesCount;
    private HugepagesSize hugepagesSize;

    public long hugepagesCount() {
        return this.hugepagesCount;
    }

    public AgentOptions withHugepagesCount(long hugepagesCount) {
        this.hugepagesCount = hugepagesCount;
        return this;
    }

    public HugepagesSize hugepagesSize() {
        return this.hugepagesSize;
    }

    public AgentOptions withHugepagesSize(HugepagesSize hugepagesSize) {
        this.hugepagesSize = hugepagesSize;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeLongField("hugepagesCount", this.hugepagesCount);
        jsonWriter.writeStringField("hugepagesSize", this.hugepagesSize == null ? null : this.hugepagesSize.toString());
        return jsonWriter.writeEndObject();
    }

    public static AgentOptions fromJson(JsonReader jsonReader) throws IOException {
        return (AgentOptions)jsonReader.readObject(reader -> {
            AgentOptions deserializedAgentOptions = new AgentOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("hugepagesCount".equals(fieldName)) {
                    deserializedAgentOptions.hugepagesCount = reader.getLong();
                    continue;
                }
                if ("hugepagesSize".equals(fieldName)) {
                    deserializedAgentOptions.hugepagesSize = HugepagesSize.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAgentOptions;
        });
    }
}

