/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.SshPublicKey;
import java.io.IOException;
import java.util.List;

public final class AdministratorConfiguration
implements JsonSerializable<AdministratorConfiguration> {
    private String adminUsername;
    private List<SshPublicKey> sshPublicKeys;

    public String adminUsername() {
        return this.adminUsername;
    }

    public AdministratorConfiguration withAdminUsername(String adminUsername) {
        this.adminUsername = adminUsername;
        return this;
    }

    public List<SshPublicKey> sshPublicKeys() {
        return this.sshPublicKeys;
    }

    public AdministratorConfiguration withSshPublicKeys(List<SshPublicKey> sshPublicKeys) {
        this.sshPublicKeys = sshPublicKeys;
        return this;
    }

    public void validate() {
        if (this.sshPublicKeys() != null) {
            this.sshPublicKeys().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("adminUsername", this.adminUsername);
        jsonWriter.writeArrayField("sshPublicKeys", this.sshPublicKeys, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AdministratorConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (AdministratorConfiguration)jsonReader.readObject(reader -> {
            AdministratorConfiguration deserializedAdministratorConfiguration = new AdministratorConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("adminUsername".equals(fieldName)) {
                    deserializedAdministratorConfiguration.adminUsername = reader.getString();
                    continue;
                }
                if ("sshPublicKeys".equals(fieldName)) {
                    List sshPublicKeys;
                    deserializedAdministratorConfiguration.sshPublicKeys = sshPublicKeys = reader.readArray(reader1 -> SshPublicKey.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAdministratorConfiguration;
        });
    }
}

