/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.L3NetworksClient;
import com.azure.resourcemanager.networkcloud.fluent.models.L3NetworkInner;
import com.azure.resourcemanager.networkcloud.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.networkcloud.implementation.L3NetworkImpl;
import com.azure.resourcemanager.networkcloud.implementation.OperationStatusResultImpl;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.models.L3Network;
import com.azure.resourcemanager.networkcloud.models.L3Networks;
import com.azure.resourcemanager.networkcloud.models.OperationStatusResult;

public final class L3NetworksImpl
implements L3Networks {
    private static final ClientLogger LOGGER = new ClientLogger(L3NetworksImpl.class);
    private final L3NetworksClient innerClient;
    private final NetworkCloudManager serviceManager;

    public L3NetworksImpl(L3NetworksClient innerClient, NetworkCloudManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<L3Network> list() {
        PagedIterable<L3NetworkInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new L3NetworkImpl((L3NetworkInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<L3Network> list(Context context) {
        PagedIterable<L3NetworkInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new L3NetworkImpl((L3NetworkInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<L3Network> listByResourceGroup(String resourceGroupName) {
        PagedIterable<L3NetworkInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new L3NetworkImpl((L3NetworkInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<L3Network> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<L3NetworkInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new L3NetworkImpl((L3NetworkInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<L3Network> getByResourceGroupWithResponse(String resourceGroupName, String l3NetworkName, Context context) {
        Response<L3NetworkInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, l3NetworkName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new L3NetworkImpl((L3NetworkInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public L3Network getByResourceGroup(String resourceGroupName, String l3NetworkName) {
        L3NetworkInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, l3NetworkName);
        if (inner != null) {
            return new L3NetworkImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult deleteByResourceGroup(String resourceGroupName, String l3NetworkName) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, l3NetworkName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult delete(String resourceGroupName, String l3NetworkName, Context context) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, l3NetworkName, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public L3Network getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String l3NetworkName = ResourceManagerUtils.getValueFromIdByName(id, "l3Networks");
        if (l3NetworkName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'l3Networks'.", id)));
        }
        return (L3Network)this.getByResourceGroupWithResponse(resourceGroupName, l3NetworkName, Context.NONE).getValue();
    }

    @Override
    public Response<L3Network> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String l3NetworkName = ResourceManagerUtils.getValueFromIdByName(id, "l3Networks");
        if (l3NetworkName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'l3Networks'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, l3NetworkName, context);
    }

    @Override
    public OperationStatusResult deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String l3NetworkName = ResourceManagerUtils.getValueFromIdByName(id, "l3Networks");
        if (l3NetworkName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'l3Networks'.", id)));
        }
        return this.delete(resourceGroupName, l3NetworkName, Context.NONE);
    }

    @Override
    public OperationStatusResult deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String l3NetworkName = ResourceManagerUtils.getValueFromIdByName(id, "l3Networks");
        if (l3NetworkName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'l3Networks'.", id)));
        }
        return this.delete(resourceGroupName, l3NetworkName, context);
    }

    private L3NetworksClient serviceClient() {
        return this.innerClient;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public L3NetworkImpl define(String name) {
        return new L3NetworkImpl(name, this.manager());
    }
}

