/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.models.L3NetworkInner;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.HybridAksIpamEnabled;
import com.azure.resourcemanager.networkcloud.models.HybridAksPluginType;
import com.azure.resourcemanager.networkcloud.models.IpAllocationType;
import com.azure.resourcemanager.networkcloud.models.L3Network;
import com.azure.resourcemanager.networkcloud.models.L3NetworkDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.L3NetworkPatchParameters;
import com.azure.resourcemanager.networkcloud.models.L3NetworkProvisioningState;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class L3NetworkImpl
implements L3Network,
L3Network.Definition,
L3Network.Update {
    private L3NetworkInner innerObject;
    private final NetworkCloudManager serviceManager;
    private String resourceGroupName;
    private String l3NetworkName;
    private L3NetworkPatchParameters updateL3NetworkUpdateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public List<String> associatedResourceIds() {
        List<String> inner = this.innerModel().associatedResourceIds();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String clusterId() {
        return this.innerModel().clusterId();
    }

    @Override
    public L3NetworkDetailedStatus detailedStatus() {
        return this.innerModel().detailedStatus();
    }

    @Override
    public String detailedStatusMessage() {
        return this.innerModel().detailedStatusMessage();
    }

    @Override
    public List<String> hybridAksClustersAssociatedIds() {
        List<String> inner = this.innerModel().hybridAksClustersAssociatedIds();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public HybridAksIpamEnabled hybridAksIpamEnabled() {
        return this.innerModel().hybridAksIpamEnabled();
    }

    @Override
    public HybridAksPluginType hybridAksPluginType() {
        return this.innerModel().hybridAksPluginType();
    }

    @Override
    public String interfaceName() {
        return this.innerModel().interfaceName();
    }

    @Override
    public IpAllocationType ipAllocationType() {
        return this.innerModel().ipAllocationType();
    }

    @Override
    public String ipv4ConnectedPrefix() {
        return this.innerModel().ipv4ConnectedPrefix();
    }

    @Override
    public String ipv6ConnectedPrefix() {
        return this.innerModel().ipv6ConnectedPrefix();
    }

    @Override
    public String l3IsolationDomainId() {
        return this.innerModel().l3IsolationDomainId();
    }

    @Override
    public L3NetworkProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public List<String> virtualMachinesAssociatedIds() {
        List<String> inner = this.innerModel().virtualMachinesAssociatedIds();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public long vlan() {
        return this.innerModel().vlan();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public L3NetworkInner innerModel() {
        return this.innerObject;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public L3NetworkImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public L3Network create() {
        this.innerObject = this.serviceManager.serviceClient().getL3Networks().createOrUpdate(this.resourceGroupName, this.l3NetworkName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public L3Network create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getL3Networks().createOrUpdate(this.resourceGroupName, this.l3NetworkName, this.innerModel(), context);
        return this;
    }

    L3NetworkImpl(String name, NetworkCloudManager serviceManager) {
        this.innerObject = new L3NetworkInner();
        this.serviceManager = serviceManager;
        this.l3NetworkName = name;
    }

    @Override
    public L3NetworkImpl update() {
        this.updateL3NetworkUpdateParameters = new L3NetworkPatchParameters();
        return this;
    }

    @Override
    public L3Network apply() {
        this.innerObject = (L3NetworkInner)((Object)this.serviceManager.serviceClient().getL3Networks().updateWithResponse(this.resourceGroupName, this.l3NetworkName, this.updateL3NetworkUpdateParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public L3Network apply(Context context) {
        this.innerObject = (L3NetworkInner)((Object)this.serviceManager.serviceClient().getL3Networks().updateWithResponse(this.resourceGroupName, this.l3NetworkName, this.updateL3NetworkUpdateParameters, context).getValue());
        return this;
    }

    L3NetworkImpl(L3NetworkInner innerObject, NetworkCloudManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.l3NetworkName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "l3Networks");
    }

    @Override
    public L3Network refresh() {
        this.innerObject = (L3NetworkInner)((Object)this.serviceManager.serviceClient().getL3Networks().getByResourceGroupWithResponse(this.resourceGroupName, this.l3NetworkName, Context.NONE).getValue());
        return this;
    }

    @Override
    public L3Network refresh(Context context) {
        this.innerObject = (L3NetworkInner)((Object)this.serviceManager.serviceClient().getL3Networks().getByResourceGroupWithResponse(this.resourceGroupName, this.l3NetworkName, context).getValue());
        return this;
    }

    @Override
    public L3NetworkImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public L3NetworkImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public L3NetworkImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }

    @Override
    public L3NetworkImpl withL3IsolationDomainId(String l3IsolationDomainId) {
        this.innerModel().withL3IsolationDomainId(l3IsolationDomainId);
        return this;
    }

    @Override
    public L3NetworkImpl withVlan(long vlan) {
        this.innerModel().withVlan(vlan);
        return this;
    }

    @Override
    public L3NetworkImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateL3NetworkUpdateParameters.withTags(tags);
        return this;
    }

    @Override
    public L3NetworkImpl withHybridAksIpamEnabled(HybridAksIpamEnabled hybridAksIpamEnabled) {
        this.innerModel().withHybridAksIpamEnabled(hybridAksIpamEnabled);
        return this;
    }

    @Override
    public L3NetworkImpl withHybridAksPluginType(HybridAksPluginType hybridAksPluginType) {
        this.innerModel().withHybridAksPluginType(hybridAksPluginType);
        return this;
    }

    @Override
    public L3NetworkImpl withInterfaceName(String interfaceName) {
        this.innerModel().withInterfaceName(interfaceName);
        return this;
    }

    @Override
    public L3NetworkImpl withIpAllocationType(IpAllocationType ipAllocationType) {
        this.innerModel().withIpAllocationType(ipAllocationType);
        return this;
    }

    @Override
    public L3NetworkImpl withIpv4ConnectedPrefix(String ipv4ConnectedPrefix) {
        this.innerModel().withIpv4ConnectedPrefix(ipv4ConnectedPrefix);
        return this;
    }

    @Override
    public L3NetworkImpl withIpv6ConnectedPrefix(String ipv6ConnectedPrefix) {
        this.innerModel().withIpv6ConnectedPrefix(ipv6ConnectedPrefix);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

